/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.util;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.util.ComplexRequirementBuilder;
import com.questhelper.requirements.util.LogicType;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.runelite.api.Client;

public final class RequirementBuilder {
    private String displayText = "";
    private Predicate<Client> requirementPredicate = client -> true;

    private RequirementBuilder(@Nonnull String displayText) {
        this.displayText = displayText;
    }

    public static ComplexRequirementBuilder complex() {
        return new ComplexRequirementBuilder(LogicType.AND, "");
    }

    public static RequirementBuilder builder(@Nonnull String displayText) {
        return new RequirementBuilder(displayText);
    }

    public static RequirementBuilder builder() {
        return RequirementBuilder.builder("");
    }

    public RequirementBuilder check(@Nonnull Predicate<Client> requirementPredicate) {
        this.requirementPredicate = requirementPredicate;
        return this;
    }

    public Requirement build() {
        return new Requirement(){

            @Override
            public boolean check(Client client) {
                return RequirementBuilder.this.requirementPredicate.test(client);
            }

            @Override
            public String getDisplayText() {
                return RequirementBuilder.this.displayText;
            }
        };
    }
}

