/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.util;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum LogicType {
    AND(Stream::allMatch, (n1, n2) -> n1.doubleValue() == n2.doubleValue()),
    OR(Stream::anyMatch, (n1, n2) -> n1.doubleValue() > 0.0),
    NAND((s, p) -> !s.allMatch(p), (n1, n2) -> n1.doubleValue() < n2.doubleValue()),
    NOR(Stream::noneMatch, (n1, n2) -> n1.doubleValue() == 0.0),
    XOR((s, p) -> s.filter(p).limit(2L).count() == 1L, (n1, n2) -> n1.doubleValue() > 0.0 && !(n2.doubleValue() > 0.0) || n2.doubleValue() > 0.0 && !(n1.doubleValue() > 0.0));

    private final BiFunction<Stream, Predicate, Boolean> function;
    private final BiFunction<Number, Number, Boolean> comparatorFunction;

    private LogicType(BiFunction<Stream, Predicate, Boolean> func, BiFunction<Number, Number, Boolean> comparator) {
        this.function = func;
        this.comparatorFunction = comparator;
    }

    public <T> boolean test(Stream<T> stream, Predicate<T> predicate) {
        return this.function.apply(stream, predicate);
    }

    public boolean compare(Number numberToCheck, Number numberToCheckAgainst) {
        return this.comparatorFunction.apply(numberToCheck, numberToCheckAgainst);
    }
}

