/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.util;

import com.questhelper.requirements.util.InventorySlots;
import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;

public enum ItemSlots {
    ANY_EQUIPPED_AND_INVENTORY(-3, "inventory or equipped", InventorySlots.EQUIPMENT_AND_INVENTORY_SLOTS),
    ANY_INVENTORY(-2, "inventory slots", InventorySlots.INVENTORY_SLOTS),
    ANY_EQUIPPED(-1, "equipped slots", InventorySlots.EQUIPMENT_SLOTS),
    HEAD(0, "head slot"),
    CAPE(1, "cape slot"),
    AMULET(2, "amulet slot"),
    WEAPON(3, "weapon slot"),
    BODY(4, "body slot"),
    SHIELD(5, "shield slot"),
    LEGS(7, "legs slot"),
    GLOVES(9, "gloves slot"),
    BOOTS(10, "boots slot"),
    RING(12, "ring slot"),
    AMMO(13, "ammo slot");

    private final int slotIdx;
    private final String name;
    private final InventorySlots inventorySlots;

    private ItemSlots(int slotIdx, String name) {
        this.slotIdx = slotIdx;
        this.name = name;
        this.inventorySlots = null;
    }

    private ItemSlots(int slotIdx, String name, InventorySlots slots) {
        this.slotIdx = slotIdx;
        this.name = name;
        this.inventorySlots = slots;
    }

    public boolean checkInventory(Client client, Predicate<Item> predicate) {
        if (this.getInventorySlots() != null) {
            return this.getInventorySlots().checkInventory(client, predicate);
        }
        if (client.getLocalPlayer() == null) {
            return false;
        }
        ItemContainer equipment = client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null || this.getSlotIdx() < 0) {
            return false;
        }
        Item item = equipment.getItem(this.getSlotIdx());
        return predicate.test(item);
    }

    public boolean contains(Client client, Predicate<Item> predicate) {
        if (this.getInventorySlots() != null) {
            return this.getInventorySlots().contains(client, predicate);
        }
        if (client.getLocalPlayer() == null) {
            return false;
        }
        ItemContainer equipment = client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null || this.getSlotIdx() < 0) {
            return false;
        }
        Item item = equipment.getItem(this.getSlotIdx());
        if (item == null) {
            return false;
        }
        return predicate.test(item);
    }

    public int getSlotIdx() {
        return this.slotIdx;
    }

    public String getName() {
        return this.name;
    }

    public InventorySlots getInventorySlots() {
        return this.inventorySlots;
    }
}

