/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.util;

import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.util.LogicType;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public final class ComplexRequirementBuilder {
    private final LogicType logicType;
    private final String displayText;
    private final List<Requirement> requirements = new LinkedList<Requirement>();

    protected ComplexRequirementBuilder(@Nonnull LogicType logicType, @Nonnull String displayText) {
        this.logicType = logicType;
        this.displayText = displayText;
    }

    public ComplexRequirementBuilder with(@Nonnull Requirement requirement) {
        this.requirements.add(requirement);
        return this;
    }

    public ComplexRequirementBuilder with(@Nonnull LogicType logicType, @Nonnull Requirement requirement) {
        this.requirements.add(new ComplexRequirement(logicType, this.displayText, requirement));
        return this;
    }

    @Nonnull
    public ComplexRequirement build() {
        return new ComplexRequirement(this.logicType, this.displayText, this.requirements.toArray(new Requirement[0]));
    }

    public static ComplexRequirementBuilder and(@Nonnull String displayText) {
        return new ComplexRequirementBuilder(LogicType.AND, displayText);
    }

    public static ComplexRequirementBuilder or(@Nonnull String displayText) {
        return new ComplexRequirementBuilder(LogicType.OR, displayText);
    }

    public static ComplexRequirementBuilder nand(@Nonnull String displayText) {
        return new ComplexRequirementBuilder(LogicType.NAND, displayText);
    }

    public static ComplexRequirementBuilder nor(@Nonnull String displayText) {
        return new ComplexRequirementBuilder(LogicType.NOR, displayText);
    }

    public static ComplexRequirementBuilder xor(@Nonnull String displayText) {
        return new ComplexRequirementBuilder(LogicType.XOR, displayText);
    }
}

