/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.runelite;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.Requirement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;

public class RuneliteRequirement
extends AbstractRequirement {
    protected final String CONFIG_GROUP = "questhelpervars";
    protected final String displayText;
    protected final String runeliteIdentifier;
    protected final String expectedValue;
    protected final ConfigManager configManager;
    protected final Map<String, Requirement> requirements;
    protected String initValue;

    public RuneliteRequirement(ConfigManager configManager, String id, String expectedValue, String text, Map<String, Requirement> requirements) {
        this(configManager, id, "false", expectedValue, text, requirements);
    }

    public RuneliteRequirement(ConfigManager configManager, String id, String expectedValue) {
        this(configManager, id, expectedValue, new HashMap<String, Requirement>());
    }

    public RuneliteRequirement(ConfigManager configManager, String id, String expectedValue, Map<String, Requirement> requirements) {
        this(configManager, id, expectedValue, "Expecting " + expectedValue, requirements);
    }

    public RuneliteRequirement(ConfigManager configManager, String id, String expectedValue, Requirement requirement) {
        this(configManager, id, expectedValue, Collections.singletonMap(expectedValue, requirement));
    }

    public RuneliteRequirement(ConfigManager configManager, String id, Requirement requirement) {
        this(configManager, id, "true", Collections.singletonMap("true", requirement));
    }

    public RuneliteRequirement(ConfigManager configManager, String id, String initValue, String expectedValue, String text, Map<String, Requirement> requirements) {
        this.configManager = configManager;
        this.runeliteIdentifier = id;
        this.displayText = text;
        this.expectedValue = expectedValue;
        this.requirements = requirements;
        this.initValue = initValue;
        this.initWithValue(initValue);
    }

    public RuneliteRequirement(ConfigManager configManager, String id, String expectedValue, String text) {
        this.configManager = configManager;
        this.runeliteIdentifier = id;
        this.displayText = text;
        this.expectedValue = expectedValue;
        this.requirements = new HashMap<String, Requirement>();
    }

    @Override
    public boolean check(Client client) {
        String value = this.getConfigValue();
        return this.expectedValue.equals(value);
    }

    public void validateCondition(Client client) {
        this.requirements.forEach((value, req) -> {
            if (req.check(client)) {
                this.setConfigValue((String)value);
            }
        });
    }

    @Override
    public String getDisplayText() {
        Object returnText = this.displayText != null ? this.displayText : "You need " + this.runeliteIdentifier;
        return returnText;
    }

    public String getConfigValue() {
        String value = this.configManager.getRSProfileConfiguration("questhelpervars", this.runeliteIdentifier);
        if (this.initValue != null && value == null) {
            this.setConfigValue(this.initValue);
            return this.initValue;
        }
        return this.configManager.getRSProfileConfiguration("questhelpervars", this.runeliteIdentifier);
    }

    public void setConfigValue(String obj) {
        if (this.configManager.getRSProfileKey() == null) {
            return;
        }
        this.configManager.setRSProfileConfiguration("questhelpervars", this.runeliteIdentifier, (Object)obj);
    }

    public boolean configExists() {
        return this.configManager.getRSProfileConfiguration("questhelpervars", this.runeliteIdentifier) != null;
    }

    public void initWithValue(String value) {
        if (!this.configExists()) {
            this.setConfigValue(value);
        }
    }

    public String getCONFIG_GROUP() {
        return this.CONFIG_GROUP;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public Map<String, Requirement> getRequirements() {
        return this.requirements;
    }
}

