/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.runelite;

import com.questhelper.questinfo.PlayerQuests;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.runeliteobjects.RuneliteConfigSetter;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;

public class PlayerQuestStateRequirement
extends RuneliteRequirement {
    private final int expectedIntValue;
    private Operation operation;
    private final PlayerQuests runeliteConfigIdentifier;

    public PlayerQuestStateRequirement(ConfigManager configManager, PlayerQuests runeliteIdentifier, int expectedValue) {
        super(configManager, runeliteIdentifier.getConfigValue(), Integer.toString(expectedValue));
        this.expectedIntValue = expectedValue;
        this.runeliteConfigIdentifier = runeliteIdentifier;
    }

    public PlayerQuestStateRequirement(ConfigManager configManager, PlayerQuests runeliteIdentifier, int expectedValue, Operation operation) {
        super(configManager, runeliteIdentifier.getConfigValue(), Integer.toString(expectedValue));
        this.operation = operation;
        this.expectedIntValue = expectedValue;
        this.runeliteConfigIdentifier = runeliteIdentifier;
    }

    public PlayerQuestStateRequirement getNewState(int incrementedStateQuantity) {
        return new PlayerQuestStateRequirement(this.configManager, this.runeliteConfigIdentifier, this.expectedIntValue + incrementedStateQuantity);
    }

    @Override
    public boolean check(Client client) {
        String value = this.getConfigValue();
        if (this.operation == null) {
            return this.expectedValue.equals(value);
        }
        try {
            int intValue = Integer.parseInt(value);
            return this.operation.check(intValue, this.expectedIntValue);
        }
        catch (NumberFormatException err) {
            System.out.println(err.getMessage());
            return false;
        }
    }

    public RuneliteConfigSetter getSetter() {
        return new RuneliteConfigSetter(this.configManager, this.runeliteIdentifier, this.expectedValue);
    }
}

