/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.quest;

import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.AbstractRequirement;
import java.util.Locale;
import net.runelite.api.Client;
import net.runelite.api.QuestState;

public class QuestRequirement
extends AbstractRequirement {
    private final QuestHelperQuest quest;
    private final QuestState requiredState;
    private final Integer minimumVarValue;
    private String displayText = null;

    public QuestRequirement(QuestHelperQuest quest, QuestState requiredState) {
        this.quest = quest;
        this.requiredState = requiredState;
        this.minimumVarValue = null;
        this.shouldCountForFilter = true;
    }

    public QuestRequirement(QuestHelperQuest quest, QuestState requiredState, String displayText) {
        this(quest, requiredState);
        this.displayText = displayText;
    }

    public QuestRequirement(QuestHelperQuest quest, int minimumVarValue) {
        this.quest = quest;
        this.requiredState = null;
        this.minimumVarValue = minimumVarValue;
        this.shouldCountForFilter = true;
    }

    public QuestRequirement(QuestHelperQuest quest, int minimumVarValue, String displayText) {
        this(quest, minimumVarValue);
        this.displayText = displayText;
    }

    @Override
    public boolean check(Client client) {
        if (this.minimumVarValue != null) {
            return this.quest.getVar(client) >= this.minimumVarValue;
        }
        QuestState state = this.quest.getState(client);
        if (this.requiredState == QuestState.IN_PROGRESS && state == QuestState.FINISHED) {
            return true;
        }
        return state == this.requiredState;
    }

    @Override
    public String getDisplayText() {
        if (this.displayText != null && !this.displayText.isEmpty()) {
            return this.displayText;
        }
        Object text = Character.toUpperCase(this.requiredState.name().charAt(0)) + this.requiredState.name().toLowerCase(Locale.ROOT).substring(1);
        if (this.requiredState == QuestState.IN_PROGRESS) {
            text = "Started ";
        }
        return ((String)text).replaceAll("_", " ") + " " + this.quest.getName();
    }

    public QuestHelperQuest getQuest() {
        return this.quest;
    }

    public QuestState getRequiredState() {
        return this.requiredState;
    }

    public Integer getMinimumVarValue() {
        return this.minimumVarValue;
    }
}

