/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.util.Operation;
import net.runelite.api.Client;

public class WeightRequirement
extends AbstractRequirement {
    private final int weight;
    private final String text;
    private final Operation operation;

    public WeightRequirement(String text, int weight, Operation operation) {
        this.weight = weight;
        this.text = text;
        this.operation = operation;
    }

    public WeightRequirement(int weight) {
        this(null, weight, Operation.EQUAL);
    }

    public WeightRequirement(int weight, Operation operation) {
        this(null, weight, operation);
    }

    @Override
    public boolean check(Client client) {
        return this.operation.check(client.getWeight(), this.weight);
    }

    @Override
    public String getDisplayText() {
        if (this.text == null) {
            return "Weight " + this.operation.getDisplayText() + " than " + this.weight;
        }
        return this.text;
    }
}

