/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.player.Boosts;
import com.questhelper.requirements.util.Operation;
import java.awt.Color;
import net.runelite.api.Client;
import net.runelite.api.Skill;

public class SkillRequirement
extends AbstractRequirement {
    private final Skill skill;
    private final int requiredLevel;
    private final Operation operation;
    private boolean canBeBoosted;
    private String displayText;
    private Boosts boosts;
    private QuestHelperPlugin questHelperPlugin;
    private Boosts selectedSkill;
    private int currentSkill;
    private int highestBoost;

    public SkillRequirement(Skill skill, int requiredLevel, Operation operation) {
        this.skill = skill;
        this.requiredLevel = requiredLevel;
        this.displayText = this.getDisplayText();
        this.operation = operation;
        this.shouldCountForFilter = true;
    }

    public SkillRequirement(Skill skill, int requiredLevel) {
        this(skill, requiredLevel, Operation.GREATER_EQUAL);
    }

    public SkillRequirement(Skill skill, int requiredLevel, boolean canBeBoosted) {
        this(skill, requiredLevel);
        this.canBeBoosted = canBeBoosted;
    }

    public SkillRequirement(Skill skill, int requiredLevel, boolean canBeBoosted, String displayText) {
        this(skill, requiredLevel, canBeBoosted);
        this.displayText = displayText;
    }

    @Override
    public boolean check(Client client) {
        int skillLevel = this.canBeBoosted ? Math.max(client.getBoostedSkillLevel(this.skill), client.getRealSkillLevel(this.skill)) : client.getRealSkillLevel(this.skill);
        return skillLevel >= this.requiredLevel;
    }

    public boolean checkRange(Skill skill, int requiredLevel, Client client, QuestHelperConfig config) {
        SkillRequirement skillRequirement = this;
        for (Boosts boostSkills : skillRequirement.boosts.values()) {
            if (!skill.getName().equals(boostSkills.getName())) continue;
            this.selectedSkill = boostSkills;
        }
        this.currentSkill = Math.max(client.getBoostedSkillLevel(skill), client.getRealSkillLevel(skill));
        this.highestBoost = this.selectedSkill.getHighestBoost();
        if (config.stewBoosts() && this.highestBoost < 5) {
            this.highestBoost = 5;
        } else if (skill == Skill.THIEVING) {
            if (client.getRealSkillLevel(skill) < 65) {
                this.highestBoost = 2;
            } else if (client.getRealSkillLevel(skill) < 45) {
                this.highestBoost = 1;
            }
        }
        return requiredLevel - this.highestBoost <= this.currentSkill;
    }

    public int checkBoosted(Client client, QuestHelperConfig config) {
        int skillLevel;
        int n = skillLevel = this.canBeBoosted ? Math.max(client.getBoostedSkillLevel(this.skill), client.getRealSkillLevel(this.skill)) : client.getRealSkillLevel(this.skill);
        if (skillLevel >= this.requiredLevel) {
            return 1;
        }
        if (this.canBeBoosted && this.checkRange(this.skill, this.requiredLevel, client, config)) {
            return 2;
        }
        return 3;
    }

    @Override
    public String getDisplayText() {
        Object returnText = this.displayText != null ? this.displayText : this.requiredLevel + " " + this.skill.getName();
        if (this.canBeBoosted) {
            returnText = (String)returnText + " (boostable)";
        }
        return returnText;
    }

    @Override
    public Color getColor(Client client, QuestHelperConfig config) {
        switch (this.checkBoosted(client, config)) {
            case 1: {
                return config.passColour();
            }
            case 2: {
                return config.boostColour();
            }
            case 3: {
                return config.failColour();
            }
        }
        return config.failColour();
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isCanBeBoosted() {
        return this.canBeBoosted;
    }

    public Boosts getBoosts() {
        return this.boosts;
    }

    public QuestHelperPlugin getQuestHelperPlugin() {
        return this.questHelperPlugin;
    }

    public Boosts getSelectedSkill() {
        return this.selectedSkill;
    }

    public int getCurrentSkill() {
        return this.currentSkill;
    }

    public int getHighestBoost() {
        return this.highestBoost;
    }
}

