/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.util.Utils;
import net.runelite.api.Client;

public class IronmanRequirement
extends AbstractRequirement {
    final boolean shouldBeIronman;

    public IronmanRequirement(boolean shouldBeIronman) {
        this.shouldBeIronman = shouldBeIronman;
    }

    @Override
    public boolean check(Client client) {
        return client.getLocalPlayer() != null && Utils.getAccountType(client).isAnyIronman() == this.shouldBeIronman;
    }

    @Override
    public String getDisplayText() {
        if (this.shouldBeIronman) {
            return "You need to be an ironman";
        }
        return "You need to not be an ironman";
    }
}

