/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.requirements.AbstractRequirement;
import java.util.Locale;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;

public class FreeInventorySlotRequirement
extends AbstractRequirement {
    private final int NUM_INVENTORY_SLOTS_TOTAL = 28;
    private InventoryID inventoryID = InventoryID.INVENTORY;
    private int numSlotsFree;

    public FreeInventorySlotRequirement(int numSlotsFree) {
        this.numSlotsFree = numSlotsFree;
    }

    @Override
    public boolean check(Client client) {
        ItemContainer container = client.getItemContainer(this.getInventoryID());
        if (container != null) {
            return 28 - container.count() >= this.getNumSlotsFree();
        }
        return false;
    }

    private boolean isOpenSlot(Item item) {
        return item == null || item.getId() == -1;
    }

    @Override
    public String getDisplayText() {
        return this.getNumSlotsFree() + " free " + this.getInventoryID().name().toLowerCase(Locale.ROOT).replaceAll("_", " ") + " slots";
    }

    public int getNUM_INVENTORY_SLOTS_TOTAL() {
        return this.NUM_INVENTORY_SLOTS_TOTAL;
    }

    public InventoryID getInventoryID() {
        return this.inventoryID;
    }

    public int getNumSlotsFree() {
        return this.numSlotsFree;
    }
}

