/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.player.Favour;
import net.runelite.api.Client;

public class FavourRequirement
extends AbstractRequirement {
    private final Favour houseFavour;
    private final int percentage;

    public FavourRequirement(Favour houseFavour, int percentage) {
        this.houseFavour = houseFavour;
        this.percentage = percentage;
        this.shouldCountForFilter = true;
    }

    @Override
    public boolean check(Client client) {
        int realFavour = client.getVarbitValue(this.houseFavour.getVarbit());
        return realFavour / 10 >= this.percentage;
    }

    @Override
    public String getDisplayText() {
        return this.percentage + "% " + this.houseFavour.getName() + " favour";
    }

    public Favour getHouseFavour() {
        return this.houseFavour;
    }

    public int getPercentage() {
        return this.percentage;
    }
}

