/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.player;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.util.Operation;
import net.runelite.api.Client;
import net.runelite.api.Player;

public class CombatLevelRequirement
extends AbstractRequirement {
    private final int requiredLevel;
    private final Operation operation;

    public CombatLevelRequirement(Operation operation, int requiredLevel) {
        this.operation = operation;
        this.requiredLevel = requiredLevel;
        this.shouldCountForFilter = true;
    }

    public CombatLevelRequirement(int requiredLevel) {
        this(Operation.GREATER_EQUAL, requiredLevel);
    }

    @Override
    public boolean check(Client client) {
        Player player = client.getLocalPlayer();
        return player != null && this.operation.check(player.getCombatLevel(), this.requiredLevel);
    }

    @Override
    public String getDisplayText() {
        return "Combat Level " + this.requiredLevel;
    }
}

