/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.npc;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.zone.Zone;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class NpcRequirement
extends AbstractRequirement {
    private final int npcID;
    private final String npcName;
    short[] npcColorOverrides;
    private final Zone zone;
    private final String displayText;
    private final boolean checkNotInZone;

    public NpcRequirement(String displayText, int npcID) {
        this(displayText, npcID, false, null);
    }

    public NpcRequirement(String displayText, int npcID, WorldPoint worldPoint) {
        this(displayText, npcID, false, new Zone(worldPoint));
    }

    public NpcRequirement(String displayText, int npcID, Zone zone) {
        this(displayText, npcID, false, zone);
    }

    public NpcRequirement(String displayText, int npcID, boolean checkNotInZone, Zone zone) {
        this(displayText, npcID, null, checkNotInZone, zone);
    }

    public NpcRequirement(String displayText, int npcID, String npcName, boolean checkNotInZone, Zone zone) {
        this.displayText = displayText;
        this.npcName = npcName;
        this.npcID = npcID;
        this.zone = zone;
        this.checkNotInZone = checkNotInZone;
    }

    public NpcRequirement(int npcID, String npcName) {
        this("DO NOT DISPLAY", npcID, npcName, false, null);
    }

    @Override
    public boolean check(Client client) {
        List found = client.getNpcs().stream().filter(npc -> npc.getId() == this.npcID).filter(npc -> this.npcName == null || npc.getName() != null && npc.getName().equals(this.npcName)).collect(Collectors.toList());
        if (!found.isEmpty()) {
            if (this.zone != null) {
                for (NPC npc2 : found) {
                    WorldPoint npcLocation = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)npc2.getLocalLocation(), (int)2);
                    if (npcLocation == null) continue;
                    boolean inZone = this.zone.contains(npcLocation);
                    return inZone && !this.checkNotInZone || !inZone && this.checkNotInZone;
                }
                return this.checkNotInZone;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayText() {
        return this.displayText;
    }

    public void setNpcColorOverrides(short[] npcColorOverrides) {
        this.npcColorOverrides = npcColorOverrides;
    }
}

