/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.npc;

import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.SimpleRequirement;
import com.questhelper.requirements.zone.Zone;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class NpcHintArrowRequirement
extends SimpleRequirement {
    private final List<Integer> npcIDs;
    private final Zone zone;

    public NpcHintArrowRequirement(int ... npcIDs) {
        this.npcIDs = Arrays.stream(npcIDs).boxed().collect(QuestUtil.collectToArrayList());
        this.zone = null;
    }

    public NpcHintArrowRequirement(WorldPoint worldPoint, int ... npcIDs) {
        this.npcIDs = Arrays.stream(npcIDs).boxed().collect(QuestUtil.collectToArrayList());
        this.zone = new Zone(worldPoint, worldPoint);
    }

    public NpcHintArrowRequirement(Zone zone, int ... npcIDs) {
        this.npcIDs = Arrays.stream(npcIDs).boxed().collect(QuestUtil.collectToArrayList());
        this.zone = zone;
    }

    @Override
    public boolean check(Client client) {
        NPC currentNPC = client.getHintArrowNpc();
        if (currentNPC == null) {
            return false;
        }
        WorldPoint wp = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)currentNPC.getLocalLocation());
        if (this.zone != null && !this.zone.contains(wp)) {
            return false;
        }
        return this.npcIDs.contains(currentNPC.getId());
    }
}

