/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.npc;

import com.questhelper.requirements.SimpleRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;

public class DialogRequirement
extends SimpleRequirement {
    String talkerName;
    final List<String> text = new ArrayList<String>();
    final boolean mustBeActive;
    boolean hasSeenDialog = false;

    public DialogRequirement(String ... text) {
        this.talkerName = null;
        this.text.addAll(Arrays.asList(text));
        this.mustBeActive = false;
    }

    public DialogRequirement(String talkerName, String text, boolean mustBeActive) {
        this.talkerName = talkerName;
        this.text.add(text);
        this.mustBeActive = mustBeActive;
    }

    public DialogRequirement(String text) {
        this(null, text, false);
    }

    @Override
    public boolean check(Client client) {
        return this.hasSeenDialog;
    }

    public void validateCondition(String dialogMessage) {
        if (!this.hasSeenDialog) {
            this.hasSeenDialog = this.isCurrentDialogMatching(dialogMessage);
        } else if (this.mustBeActive) {
            this.hasSeenDialog = this.isCurrentDialogMatching(dialogMessage);
        }
    }

    private boolean isCurrentDialogMatching(String dialogMessage) {
        if (this.talkerName != null && !dialogMessage.contains(this.talkerName + "|")) {
            return false;
        }
        return this.text.stream().anyMatch(dialogMessage::contains);
    }

    public void setTalkerName(String talkerName) {
        this.talkerName = talkerName;
    }
}

