/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.location;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.steps.tools.QuestPerspective;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class TileIsLoadedRequirement
extends AbstractRequirement {
    private final WorldPoint worldPoint;
    private final String displayText;

    public TileIsLoadedRequirement(WorldPoint worldPoint) {
        this.worldPoint = worldPoint;
        this.displayText = "WorldPoint " + worldPoint.toString() + "is loaded locally.";
    }

    @Override
    public boolean check(Client client) {
        LocalPoint lp = QuestPerspective.getInstanceLocalPointFromReal(client, this.worldPoint);
        if (lp == null) {
            return false;
        }
        if (lp.getSceneX() == 103) {
            return false;
        }
        return lp.getSceneY() != 103;
    }

    @Override
    @Nonnull
    public String getDisplayText() {
        return this.displayText == null ? "" : this.displayText;
    }
}

