/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.QuestHelperConfig;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.ItemSlots;
import java.awt.Color;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.runelite.api.Client;

public class NoItemRequirement
extends ItemRequirement {
    private final ItemSlots slot;

    public NoItemRequirement(String text, @Nonnull ItemSlots slot) {
        super(text, -1, -1);
        this.slot = slot;
    }

    @Override
    public boolean check(Client client) {
        return this.slot.checkInventory(client, Objects::isNull);
    }

    @Override
    public Color getColor(Client client, QuestHelperConfig config) {
        return this.check(client) ? config.passColour() : config.failColour();
    }

    @Override
    public String getDisplayText() {
        return "Nothing in your " + this.slot.getName();
    }

    @Override
    protected NoItemRequirement copyOfClass() {
        return new NoItemRequirement(this.getName(), this.slot);
    }
}

