/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.QuestHelperConfig;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.client.config.ConfigManager;

public class KeyringRequirement
extends ItemRequirement {
    RuneliteRequirement runeliteRequirement;
    KeyringCollection keyringCollection;
    ConfigManager configManager;
    ItemRequirement keyring = new ItemRequirement("Steel key ring", 4446);

    public KeyringRequirement(String name, ConfigManager configManager, KeyringCollection key) {
        super(name, key.getItemID());
        this.runeliteRequirement = new RuneliteRequirement(configManager, key.runeliteName(), "true", key.toChatText());
        this.keyringCollection = key;
        this.configManager = configManager;
    }

    public KeyringRequirement(ConfigManager configManager, KeyringCollection key) {
        super(key.toChatText(), key.getItemID());
        this.runeliteRequirement = new RuneliteRequirement(configManager, key.runeliteName(), "true", key.toChatText());
        this.keyringCollection = key;
        this.configManager = configManager;
    }

    public String chatboxText() {
        return this.keyringCollection.toChatText();
    }

    public void setConfigValue(String value) {
        this.runeliteRequirement.setConfigValue(value);
    }

    @Override
    public ItemRequirement copy() {
        KeyringRequirement newItem = new KeyringRequirement(this.getName(), this.configManager, this.keyringCollection);
        newItem.addAlternates(this.alternateItems);
        newItem.setDisplayItemId(this.getDisplayItemId());
        newItem.setExclusiveToOneItemType(this.exclusiveToOneItemType);
        newItem.setHighlightInInventory(this.highlightInInventory);
        newItem.setDisplayMatchedItemName(this.isDisplayMatchedItemName());
        newItem.setConditionToHide(this.getConditionToHide());
        newItem.setQuestBank(this.getQuestBank());
        newItem.setTooltip(this.getTooltip());
        newItem.setUrlSuffix(this.getUrlSuffix());
        return newItem;
    }

    @Override
    public boolean check(Client client, boolean checkConsideringSlotRestrictions, List<Item> items) {
        boolean match = this.runeliteRequirement.check(client);
        if (match && this.keyring.check(client)) {
            return true;
        }
        return super.check(client, checkConsideringSlotRestrictions, items);
    }

    @Override
    public Color getColorConsideringBank(Client client, boolean checkConsideringSlotRestrictions, List<Item> bankItems, QuestHelperConfig config) {
        boolean match;
        Color color = config.failColour();
        if (!this.isActualItem()) {
            color = Color.GRAY;
        } else if (super.check(client, checkConsideringSlotRestrictions, new ArrayList<Item>())) {
            color = config.passColour();
        }
        if (color == config.failColour() && bankItems != null && super.check(client, false, bankItems)) {
            color = Color.WHITE;
        }
        if (color == config.failColour() && (match = this.runeliteRequirement.check(client))) {
            color = Color.ORANGE;
        }
        return color;
    }

    @Override
    protected KeyringRequirement copyOfClass() {
        return new KeyringRequirement(this.getName(), this.configManager, this.keyringCollection);
    }
}

