/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.QuestHelperConfig;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.Item;

public class ItemRequirements
extends ItemRequirement {
    ArrayList<ItemRequirement> itemRequirements = new ArrayList();
    LogicType logicType;

    public ItemRequirements(ItemRequirement ... requirements) {
        this("", requirements);
    }

    public ItemRequirements(String name, ItemRequirement ... itemRequirements) {
        super(name, itemRequirements[0].getId(), -1);
        this.itemRequirements.addAll(Arrays.asList(itemRequirements));
        this.logicType = LogicType.AND;
    }

    public ItemRequirements(LogicType logicType, String name, ItemRequirement ... itemRequirements) {
        super(name, itemRequirements[0].getId(), -1);
        this.itemRequirements.addAll(Arrays.asList(itemRequirements));
        this.logicType = logicType;
    }

    public ItemRequirements(LogicType logicType, String name, List<ItemRequirement> itemRequirements) {
        super(name, itemRequirements.get(0).getId(), -1);
        this.itemRequirements.addAll(itemRequirements);
        this.logicType = logicType;
    }

    public ItemRequirements(LogicType logicType, ItemRequirement ... requirements) {
        this(logicType, "", requirements);
    }

    @Override
    public boolean isActualItem() {
        return LogicType.OR.test(this.getItemRequirements().stream(), item -> !item.getAllIds().contains(-1) && item.getQuantity() >= 0);
    }

    @Override
    public boolean check(Client client) {
        return this.check(client, false);
    }

    @Override
    public boolean check(Client client, boolean checkConsideringSlotRestrictions) {
        Predicate<ItemRequirement> predicate = r -> r.check(client, checkConsideringSlotRestrictions);
        int successes = (int)this.itemRequirements.stream().filter(Objects::nonNull).filter(predicate).count();
        this.hadItemLastCheck = this.logicType.compare(successes, this.itemRequirements.size());
        return this.hadItemLastCheck;
    }

    @Override
    public boolean check(Client client, boolean checkConsideringSlotRestrictions, List<Item> items) {
        Predicate<ItemRequirement> predicate = r -> r.check(client, checkConsideringSlotRestrictions, items);
        int successes = (int)this.itemRequirements.stream().filter(Objects::nonNull).filter(predicate).count();
        this.hadItemLastCheck = this.logicType.compare(successes, this.itemRequirements.size());
        return this.hadItemLastCheck;
    }

    @Override
    public Color getColor(Client client, QuestHelperConfig config) {
        return this.check(client, true) ? config.passColour() : config.failColour();
    }

    @Override
    public Color getColorConsideringBank(Client client, boolean checkConsideringSlotRestrictions, List<Item> bankItems, QuestHelperConfig config) {
        Color color = config.failColour();
        if (!this.isActualItem() && this.getItemRequirements() == null) {
            color = Color.GRAY;
        } else if (this.check(client, checkConsideringSlotRestrictions)) {
            color = config.passColour();
        }
        if (color == config.failColour() && bankItems != null && this.check(client, false, bankItems)) {
            color = Color.WHITE;
        }
        return color;
    }

    @Override
    public ItemRequirement copy() {
        ItemRequirements newItem = new ItemRequirements(this.getLogicType(), this.getName(), this.getItemRequirements());
        newItem.addAlternates(this.alternateItems);
        newItem.setDisplayItemId(this.getDisplayItemId());
        newItem.setExclusiveToOneItemType(this.exclusiveToOneItemType);
        newItem.setHighlightInInventory(this.highlightInInventory);
        newItem.setDisplayMatchedItemName(this.isDisplayMatchedItemName());
        newItem.setConditionToHide(this.getConditionToHide());
        newItem.setQuestBank(this.getQuestBank());
        newItem.setTooltip(this.getTooltip());
        newItem.logicType = this.logicType;
        newItem.additionalOptions = this.additionalOptions;
        return newItem;
    }

    @Override
    public List<Integer> getAllIds() {
        return this.itemRequirements.stream().map(ItemRequirement::getAllIds).flatMap(Collection::stream).collect(QuestUtil.collectToArrayList());
    }

    @Override
    public boolean checkBank(Client client) {
        return this.logicType.test(this.getItemRequirements().stream(), item -> item.checkBank(client) || item.check(client, false));
    }

    public ArrayList<ItemRequirement> getItemRequirements() {
        return this.itemRequirements;
    }

    public LogicType getLogicType() {
        return this.logicType;
    }
}

