/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.QuestHelperConfig;
import com.questhelper.bank.QuestBank;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.ItemWithCharge;
import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.util.InventorySlots;
import com.questhelper.requirements.util.LogicType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.ui.overlay.components.LineComponent;

public class ItemRequirement
extends AbstractRequirement {
    private int id;
    private String name;
    private Integer displayItemId;
    protected int quantity;
    private boolean equip;
    protected boolean highlightInInventory;
    protected final List<Integer> alternateItems = new ArrayList<Integer>();
    protected boolean exclusiveToOneItemType;
    private boolean displayMatchedItemName;
    protected Requirement conditionToHide;
    private QuestBank questBank;
    protected boolean hadItemLastCheck;
    protected boolean isConsumedItem = true;
    protected boolean shouldAggregate = true;
    protected boolean isChargedItem = false;
    protected Requirement additionalOptions;

    public ItemRequirement(String name, int id) {
        this(name, id, 1);
    }

    public ItemRequirement(String name, int id, int quantity) {
        this.id = id;
        this.quantity = quantity;
        this.name = name;
        this.equip = false;
    }

    public ItemRequirement(String name, int id, int quantity, boolean equip) {
        this(name, id, quantity);
        this.equip = equip;
    }

    public ItemRequirement(boolean highlightInInventory, String name, int id) {
        this(name, id);
        this.highlightInInventory = highlightInInventory;
    }

    public ItemRequirement(String name, List<Integer> items) {
        this(name, items.get(0), 1);
        this.addAlternates(items.subList(1, items.size()));
    }

    public ItemRequirement(String name, List<Integer> items, int quantity) {
        this(name, items.get(0), quantity);
        this.addAlternates(items.subList(1, items.size()));
    }

    public ItemRequirement(String name, List<Integer> items, int quantity, boolean equip) {
        this(name, items.get(0), quantity);
        this.equip = equip;
        this.addAlternates(items.subList(1, items.size()));
    }

    public ItemRequirement(String name, ItemCollections itemCollection) {
        this(name, itemCollection.getItems().get(0), 1);
        this.setUrlSuffix(itemCollection.getWikiTerm());
        this.addAlternates(itemCollection.getItems().subList(1, itemCollection.getItems().size()));
    }

    public ItemRequirement(String name, ItemCollections itemCollection, int quantity) {
        this(name, itemCollection.getItems().get(0), quantity);
        this.setUrlSuffix(itemCollection.getWikiTerm());
        this.addAlternates(itemCollection.getItems().subList(1, itemCollection.getItems().size()));
    }

    public ItemRequirement(String name, ItemCollections itemCollection, int quantity, boolean equip) {
        this(name, itemCollection.getItems().get(0), quantity);
        this.setUrlSuffix(itemCollection.getWikiTerm());
        this.equip = equip;
        this.addAlternates(itemCollection.getItems().subList(1, itemCollection.getItems().size()));
    }

    public void addAlternates(List<Integer> alternates) {
        this.alternateItems.addAll(alternates);
    }

    public void addAlternates(ItemCollections alternates) {
        this.alternateItems.addAll(alternates.getItems());
    }

    public void addAlternates(Integer ... alternates) {
        this.alternateItems.addAll(Arrays.asList(alternates));
    }

    public boolean showQuantity() {
        return this.quantity != -1;
    }

    public ItemRequirement highlighted() {
        ItemRequirement newItem = this.copy();
        newItem.setHighlightInInventory(true);
        return newItem;
    }

    public ItemRequirement alsoCheckBank(QuestBank questBank) {
        ItemRequirement newItem = this.copy();
        newItem.questBank = questBank;
        return newItem;
    }

    public ItemRequirement named(String name) {
        ItemRequirement newItem = this.copy();
        newItem.setName(name);
        return newItem;
    }

    public ItemRequirement equipped() {
        ItemRequirement newItem = this.copy();
        newItem.setEquip(true);
        return newItem;
    }

    public ItemRequirement isNotConsumed() {
        ItemRequirement newItem = this.copy();
        newItem.isConsumedItem = false;
        return newItem;
    }

    public ItemRequirement doNotAggregate() {
        ItemRequirement newItem = this.copy();
        newItem.shouldAggregate = false;
        return newItem;
    }

    public ItemRequirement quantity(int newQuantity) {
        ItemRequirement newItem = this.copy();
        newItem.setQuantity(newQuantity);
        return newItem;
    }

    public ItemRequirement hideConditioned(Requirement condition) {
        ItemRequirement newItem = this.copy();
        newItem.setConditionToHide(condition);
        return newItem;
    }

    public ItemRequirement showConditioned(Requirement condition) {
        ItemRequirement newItem = this.copy();
        newItem.setConditionToHide(new Conditions(LogicType.NOR, condition));
        return newItem;
    }

    protected ItemRequirement copyOfClass() {
        if (this.getClass() != ItemRequirement.class) {
            throw new UnsupportedOperationException("Subclasses must override copy()");
        }
        return new ItemRequirement(this.name, this.id, this.quantity, this.equip);
    }

    public ItemRequirement copy() {
        ItemRequirement newItem = this.copyOfClass();
        newItem.setName(this.name);
        newItem.setId(this.id);
        newItem.setEquip(this.equip);
        newItem.setQuantity(this.quantity);
        newItem.addAlternates(this.alternateItems);
        newItem.setDisplayItemId(this.displayItemId);
        newItem.setExclusiveToOneItemType(this.exclusiveToOneItemType);
        newItem.setHighlightInInventory(this.highlightInInventory);
        newItem.setDisplayMatchedItemName(this.displayMatchedItemName);
        newItem.setConditionToHide(this.conditionToHide);
        newItem.questBank = this.questBank;
        newItem.hadItemLastCheck = this.hadItemLastCheck;
        newItem.isConsumedItem = this.isConsumedItem;
        newItem.shouldAggregate = this.shouldAggregate;
        newItem.setTooltip(this.getTooltip());
        newItem.setUrlSuffix(this.getUrlSuffix());
        newItem.additionalOptions = this.additionalOptions;
        newItem.isChargedItem = this.isChargedItem;
        return newItem;
    }

    public boolean isActualItem() {
        return this.id != -1 && this.quantity != -1;
    }

    public void canBeObtainedDuringQuest() {
        this.appendToTooltip("Can be obtained during the quest.");
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getAllIds() {
        ArrayList<Integer> items = new ArrayList<Integer>(Collections.singletonList(this.id));
        items.addAll(this.alternateItems);
        return items.stream().distinct().collect(Collectors.toList());
    }

    @Override
    protected List<LineComponent> getOverlayDisplayText(Client client, QuestHelperConfig config) {
        ArrayList<LineComponent> lines = new ArrayList<LineComponent>();
        if (!this.shouldDisplayText(client)) {
            return lines;
        }
        StringBuilder text = new StringBuilder();
        if (this.showQuantity()) {
            text.append(this.getQuantity()).append(" x ");
        }
        int itemID = this.findItemID(client, false);
        if (this.displayMatchedItemName && (this.alternateItems.contains(itemID) || this.id == itemID)) {
            text.append(client.getItemDefinition(itemID).getName());
        } else {
            text.append(this.getName());
        }
        Color color = this.getColor(client, config);
        lines.add(LineComponent.builder().left(text.toString()).leftColor(color).build());
        lines.addAll(this.getAdditionalText(client, true, config));
        return lines;
    }

    @Override
    public String getDisplayText() {
        return this.getName();
    }

    public String getSidebarText() {
        StringBuilder text = new StringBuilder();
        if (this.showQuantity()) {
            text.append(this.getQuantity()).append(" x ");
        }
        text.append(this.getDisplayText());
        String html1 = "<html><body style='padding: 0px; margin: 0px; width: 140px'>";
        String html2 = "</body></html>";
        return html1 + text + html2;
    }

    @Override
    public boolean shouldDisplayText(Client client) {
        return this.conditionToHide == null || !this.conditionToHide.check(client);
    }

    @Override
    public Color getColor(Client client, QuestHelperConfig config) {
        Color color = config.failColour();
        if (!this.isActualItem()) {
            color = Color.GRAY;
        } else if (this.check(client)) {
            color = config.passColour();
        }
        return color;
    }

    private int findItemID(Client client, boolean checkConsideringSlotRestrictions) {
        int remainder = this.getRequiredItemDifference(client, this.id, checkConsideringSlotRestrictions, null);
        if (remainder <= 0) {
            return this.id;
        }
        List<Integer> ids = this.getAllIds();
        for (int alternate : ids) {
            if (this.exclusiveToOneItemType) {
                remainder = this.quantity;
            }
            if ((remainder -= this.quantity - this.getRequiredItemDifference(client, alternate, checkConsideringSlotRestrictions, null)) > 0) continue;
            return alternate;
        }
        return -1;
    }

    public Color getColorConsideringBank(Client client, boolean checkConsideringSlotRestrictions, List<Item> bankItems, QuestHelperConfig config) {
        Color color = config.failColour();
        if (!this.isActualItem()) {
            color = Color.GRAY;
        } else if (this.check(client, checkConsideringSlotRestrictions)) {
            color = config.passColour();
        }
        if (color == config.failColour() && bankItems != null && this.check(client, false, bankItems)) {
            color = Color.WHITE;
        }
        return color;
    }

    protected ArrayList<LineComponent> getAdditionalText(Client client, boolean includeTooltip, QuestHelperConfig config) {
        Color equipColor = config.passColour();
        ArrayList<LineComponent> lines = new ArrayList<LineComponent>();
        if (this.isEquip()) {
            String equipText = "(equipped)";
            if (!this.check(client, true)) {
                equipColor = config.failColour();
            }
            lines.add(LineComponent.builder().left(equipText).leftColor(equipColor).build());
        }
        if (includeTooltip && this.getTooltip() != null && !this.check(client)) {
            lines.add(LineComponent.builder().left("- " + this.getTooltip()).leftColor(Color.WHITE).build());
        }
        return lines;
    }

    public int getMatches(Client client) {
        return this.getMatches(client, false, new ArrayList<Item>());
    }

    public int getMatches(Client client, boolean checkConsideringSlotRestrictions, List<Item> items) {
        ArrayList<Item> allItems = new ArrayList<Item>(items);
        if (this.questBank != null && this.questBank.getBankItems() != null) {
            allItems.addAll(this.questBank.getBankItems());
        }
        int remainder = 0;
        List<Integer> ids = this.getAllIds();
        for (int alternate : ids) {
            if (this.exclusiveToOneItemType) {
                remainder = this.quantity;
            }
            remainder += this.quantity - this.getRequiredItemDifference(client, alternate, checkConsideringSlotRestrictions, allItems);
        }
        return remainder;
    }

    public boolean check(Client client, boolean checkConsideringSlotRestrictions, List<Item> items) {
        if (!this.shouldDisplayText(client)) {
            return false;
        }
        if (this.additionalOptions != null && this.additionalOptions.check(client)) {
            return true;
        }
        ArrayList<Item> allItems = new ArrayList<Item>(items);
        if (this.questBank != null && this.questBank.getBankItems() != null) {
            allItems.addAll(this.questBank.getBankItems());
        }
        int remainder = this.quantity;
        List<Integer> ids = this.getAllIds();
        for (int alternate : ids) {
            if (this.exclusiveToOneItemType) {
                remainder = this.quantity;
            }
            if ((remainder -= this.quantity - this.getRequiredItemDifference(client, alternate, checkConsideringSlotRestrictions, allItems)) > 0) continue;
            this.hadItemLastCheck = true;
            return true;
        }
        this.hadItemLastCheck = false;
        return false;
    }

    public int getRequiredItemDifference(Client client, int itemID, boolean checkConsideringSlotRestrictions, List<Item> items) {
        ItemContainer inventory;
        ItemContainer equipped = client.getItemContainer(InventoryID.EQUIPMENT);
        int tempQuantity = this.quantity;
        if (equipped != null) {
            tempQuantity -= this.getNumMatches(equipped, itemID);
        }
        if (!(checkConsideringSlotRestrictions && this.equip || (inventory = client.getItemContainer(InventoryID.INVENTORY)) == null)) {
            tempQuantity -= this.getNumMatches(inventory, itemID);
        }
        if (items != null) {
            tempQuantity -= this.getNumMatches(items, itemID);
        }
        return tempQuantity;
    }

    public int getNumMatches(ItemContainer items, int itemID) {
        return this.getNumMatches(Arrays.asList((Item[])items.getItems().clone()), itemID);
    }

    public int getNumMatches(List<Item> items, int itemID) {
        if (this.isChargedItem) {
            return items.stream().filter(Objects::nonNull).filter(i -> i.getId() == itemID).mapToInt(i -> {
                ItemWithCharge itemWithCharge = ItemWithCharge.findItem(i.getId());
                if (itemWithCharge != null) {
                    return itemWithCharge.getCharges();
                }
                return i.getQuantity();
            }).sum();
        }
        return items.stream().filter(Objects::nonNull).filter(i -> i.getId() == itemID).mapToInt(Item::getQuantity).sum();
    }

    @Override
    public boolean check(Client client) {
        return this.check(client, false);
    }

    public boolean check(Client client, boolean checkConsideringSlotRestrictions) {
        return this.check(client, checkConsideringSlotRestrictions, new ArrayList<Item>());
    }

    public boolean checkBank(Client client) {
        return InventorySlots.BANK.contains(client, item -> this.getDisplayItemIds().contains(item.getId()));
    }

    public List<Integer> getDisplayItemIds() {
        if (this.displayItemId == null) {
            return this.getAllIds();
        }
        return Collections.singletonList(this.displayItemId);
    }

    public boolean shouldRenderItemHighlights(Client client) {
        return this.conditionToHide == null || !this.conditionToHide.check(client);
    }

    public boolean shouldHighlightInInventory(Client client) {
        return this.highlightInInventory && this.shouldRenderItemHighlights(client);
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayItemId(Integer displayItemId) {
        this.displayItemId = displayItemId;
    }

    public Integer getDisplayItemId() {
        return this.displayItemId;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean isEquip() {
        return this.equip;
    }

    public void setEquip(boolean equip) {
        this.equip = equip;
    }

    public void setHighlightInInventory(boolean highlightInInventory) {
        this.highlightInInventory = highlightInInventory;
    }

    public void setExclusiveToOneItemType(boolean exclusiveToOneItemType) {
        this.exclusiveToOneItemType = exclusiveToOneItemType;
    }

    public void setDisplayMatchedItemName(boolean displayMatchedItemName) {
        this.displayMatchedItemName = displayMatchedItemName;
    }

    public boolean isDisplayMatchedItemName() {
        return this.displayMatchedItemName;
    }

    public void setConditionToHide(Requirement conditionToHide) {
        this.conditionToHide = conditionToHide;
    }

    public Requirement getConditionToHide() {
        return this.conditionToHide;
    }

    public QuestBank getQuestBank() {
        return this.questBank;
    }

    public void setQuestBank(QuestBank questBank) {
        this.questBank = questBank;
    }

    public boolean isHadItemLastCheck() {
        return this.hadItemLastCheck;
    }

    public boolean isConsumedItem() {
        return this.isConsumedItem;
    }

    public void setChargedItem(boolean isChargedItem) {
        this.isChargedItem = isChargedItem;
    }

    public boolean isChargedItem() {
        return this.isChargedItem;
    }

    public void setAdditionalOptions(Requirement additionalOptions) {
        this.additionalOptions = additionalOptions;
    }
}

