/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.requirements.conditional.ConditionForStep;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.tools.QuestPerspective;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class ItemOnTileRequirement
extends ConditionForStep {
    private final List<Integer> itemID;
    private WorldPoint worldPoint;

    public ItemOnTileRequirement(int itemID) {
        this.itemID = Collections.singletonList(itemID);
    }

    public ItemOnTileRequirement(ItemRequirement item) {
        this.itemID = item.getAllIds();
    }

    public ItemOnTileRequirement(int itemID, WorldPoint worldPoint) {
        this.itemID = Collections.singletonList(itemID);
        this.worldPoint = worldPoint;
    }

    public ItemOnTileRequirement(ItemRequirement item, WorldPoint worldPoint) {
        this.itemID = item.getAllIds();
        this.worldPoint = worldPoint;
    }

    @Override
    public boolean check(Client client) {
        return this.checkAllTiles(client);
    }

    private boolean checkAllTiles(Client client) {
        Tile[][] squareOfTiles;
        if (this.worldPoint != null) {
            LocalPoint localPoint = QuestPerspective.getInstanceLocalPointFromReal(client, this.worldPoint);
            if (localPoint == null) {
                return false;
            }
            Tile tile = client.getScene().getTiles()[client.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()];
            if (tile != null) {
                List items = tile.getGroundItems();
                if (items == null) {
                    return false;
                }
                for (TileItem item : items) {
                    if (!this.itemID.contains(item.getId())) continue;
                    return true;
                }
                return false;
            }
        }
        Tile[][] tileArray = squareOfTiles = client.getScene().getTiles()[client.getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] lineOfTiles;
            for (Tile tile : lineOfTiles = tileArray[i]) {
                List items;
                if (tile == null || (items = tile.getGroundItems()) == null) continue;
                for (TileItem item : items) {
                    if (!this.itemID.contains(item.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

