/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.InitializableRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.location.TileIsLoadedRequirement;
import com.questhelper.steps.tools.QuestPerspective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class ItemOnTileConsideringSceneLoadRequirement
implements InitializableRequirement {
    private final List<Integer> itemID;
    private WorldPoint worldPoint;
    private final int MAX_ZONE = 27;
    private boolean hasFoundItemThisLoad = true;
    private boolean playerHasBeenInRegionThisLoad;
    private TileIsLoadedRequirement tileLoadedReq;

    public ItemOnTileConsideringSceneLoadRequirement(ItemRequirement item, WorldPoint worldPoint) {
        this.itemID = item.getAllIds();
        this.worldPoint = worldPoint;
        this.tileLoadedReq = new TileIsLoadedRequirement(worldPoint);
    }

    public ItemOnTileConsideringSceneLoadRequirement(int itemID, WorldPoint worldPoint) {
        this.itemID = Collections.singletonList(itemID);
        this.worldPoint = worldPoint;
        this.tileLoadedReq = new TileIsLoadedRequirement(worldPoint);
    }

    @Override
    public boolean check(Client client) {
        if (this.playerInRegion(client) || this.playerHasBeenInRegionThisLoad) {
            this.hasFoundItemThisLoad = this.checkAllTiles(client);
        }
        return this.hasFoundItemThisLoad;
    }

    @Override
    @NonNull
    public String getDisplayText() {
        return "";
    }

    private boolean playerInRegion(Client client) {
        if (this.worldPoint == null) {
            return true;
        }
        if (!this.tileLoadedReq.check(client)) {
            return true;
        }
        WorldPoint playerPoint = QuestPerspective.getRealWorldPointFromLocal(client, client.getLocalPlayer().getWorldLocation());
        if (playerPoint == null) {
            return false;
        }
        if (playerPoint.distanceTo(this.worldPoint) <= 27) {
            this.playerHasBeenInRegionThisLoad = true;
            return true;
        }
        return false;
    }

    private boolean checkAllTiles(Client client) {
        Tile[][] squareOfTiles;
        if (this.worldPoint != null) {
            LocalPoint localPoint = QuestPerspective.getInstanceLocalPointFromReal(client, this.worldPoint);
            if (localPoint == null) {
                return false;
            }
            Tile tile = client.getScene().getTiles()[client.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()];
            if (tile != null) {
                List items = tile.getGroundItems();
                if (items == null) {
                    return false;
                }
                for (TileItem item : items) {
                    if (!this.itemID.contains(item.getId())) continue;
                    return true;
                }
                return false;
            }
        }
        Tile[][] tileArray = squareOfTiles = client.getScene().getTiles()[client.getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] lineOfTiles;
            for (Tile tile : lineOfTiles = tileArray[i]) {
                List items;
                if (tile == null || (items = tile.getGroundItems()) == null) continue;
                for (TileItem item : items) {
                    if (!this.itemID.contains(item.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void initialize(Client client) {
    }

    @Override
    public void updateHandler() {
        this.playerHasBeenInRegionThisLoad = false;
        this.hasFoundItemThisLoad = true;
    }

    @Override
    @NonNull
    public List<Requirement> getConditions() {
        return new ArrayList<Requirement>();
    }
}

