/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.item;

import com.questhelper.collections.ItemCollections;
import com.questhelper.requirements.item.ItemRequirement;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Item;

public class FollowerItemRequirement
extends ItemRequirement {
    private final List<Integer> followerIDs;
    private final List<Integer> itemIDs;

    public FollowerItemRequirement(String name, List<Integer> itemIDs, List<Integer> followerIDs) {
        super(name, itemIDs);
        this.itemIDs = itemIDs;
        this.followerIDs = followerIDs;
    }

    public FollowerItemRequirement(String name, ItemCollections itemIDs, List<Integer> followerIDs) {
        super(name, itemIDs);
        this.itemIDs = itemIDs.getItems();
        this.followerIDs = followerIDs;
    }

    @Override
    protected FollowerItemRequirement copyOfClass() {
        return new FollowerItemRequirement(this.getName(), this.itemIDs, this.followerIDs);
    }

    @Override
    public boolean check(Client client, boolean checkConsideringSlotRestrictions, List<Item> items) {
        boolean match = client.getNpcs().stream().filter(npc -> npc.getInteracting() != null).filter(npc -> npc.getInteracting() == client.getLocalPlayer()).anyMatch(npc -> this.followerIDs.contains(npc.getId()));
        if (match) {
            return true;
        }
        return super.check(client, checkConsideringSlotRestrictions, items);
    }
}

