/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.conditional;

import com.questhelper.requirements.conditional.ConditionForStep;
import com.questhelper.requirements.zone.Zone;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class ObjectCondition
extends ConditionForStep {
    private final int objectID;
    private final Zone zone;
    private int maxDistanceFromPlayer = -1;
    private boolean onlyCheckGameObjects = false;

    public ObjectCondition(int objectID) {
        this.objectID = objectID;
        this.zone = null;
    }

    public ObjectCondition(int objectID, WorldPoint worldPoint) {
        this.objectID = objectID;
        this.zone = new Zone(worldPoint);
    }

    public ObjectCondition(int objectID, Zone zone) {
        this.objectID = objectID;
        this.zone = zone;
    }

    @Override
    public boolean check(Client client) {
        Tile[][] tiles = client.getScene().getTiles()[client.getPlane()];
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                if (!this.checkTile(tiles[x][y], client)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkTile(Tile tile, Client client) {
        boolean playerClose;
        if (tile == null) {
            return false;
        }
        WorldPoint wp = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)tile.getLocalLocation());
        if (this.zone != null && !this.zone.contains(wp)) {
            return false;
        }
        WorldPoint playerLocation = client.getLocalPlayer().getWorldLocation();
        boolean bl = playerClose = this.maxDistanceFromPlayer == -1 || playerLocation.distanceTo(wp) < this.maxDistanceFromPlayer;
        if (!playerClose) {
            return false;
        }
        for (GameObject object : tile.getGameObjects()) {
            if (!this.checkForObjects((TileObject)object)) continue;
            return true;
        }
        if (this.onlyCheckGameObjects) {
            return false;
        }
        if (this.checkForObjects((TileObject)tile.getDecorativeObject())) {
            return true;
        }
        if (this.checkForObjects((TileObject)tile.getGroundObject())) {
            return true;
        }
        return this.checkForObjects((TileObject)tile.getWallObject());
    }

    private boolean checkForObjects(TileObject object) {
        return object != null && (object.getId() == this.objectID || this.objectID == -1);
    }

    @Override
    public void updateHandler() {
    }

    public void setMaxDistanceFromPlayer(int maxDistanceFromPlayer) {
        this.maxDistanceFromPlayer = maxDistanceFromPlayer;
    }

    public void setOnlyCheckGameObjects(boolean onlyCheckGameObjects) {
        this.onlyCheckGameObjects = onlyCheckGameObjects;
    }
}

