/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.conditional;

import com.questhelper.requirements.conditional.ConditionForStep;
import com.questhelper.requirements.zone.Zone;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.NpcChanged;

public class NpcCondition
extends ConditionForStep {
    private final int npcID;
    private final ArrayList<NPC> npcs = new ArrayList();
    private boolean npcInScene = false;
    private final Zone zone;

    public NpcCondition(int npcID) {
        this.npcID = npcID;
        this.zone = null;
    }

    public NpcCondition(int npcID, WorldPoint worldPoint) {
        this.npcID = npcID;
        this.zone = new Zone(worldPoint, worldPoint);
    }

    public NpcCondition(int npcID, Zone zone) {
        this.npcID = npcID;
        this.zone = zone;
    }

    @Override
    public void initialize(Client client) {
        for (NPC npc : client.getNpcs()) {
            if (this.npcID != npc.getId()) continue;
            this.npcs.add(npc);
            this.npcInScene = true;
        }
    }

    @Override
    public boolean check(Client client) {
        if (this.zone != null) {
            for (NPC npc : this.npcs) {
                WorldPoint wp;
                if (npc == null || (wp = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)npc.getLocalLocation())) == null || !this.zone.contains(wp)) continue;
                return true;
            }
            return false;
        }
        return this.npcInScene;
    }

    public void checkNpcSpawned(NPC npc) {
        if (npc.getId() == this.npcID) {
            this.npcs.add(npc);
            this.npcInScene = true;
        }
    }

    public void checkNpcDespawned(NPC npc) {
        if (this.npcs.contains(npc)) {
            this.npcs.remove(npc);
            this.npcInScene = false;
        }
    }

    public void checkNpcChanged(NpcChanged npcChanged) {
        if (this.npcs.contains(npcChanged.getNpc()) && npcChanged.getNpc().getId() != this.npcID) {
            this.npcs.remove(npcChanged.getNpc());
            this.npcInScene = false;
        }
        if (npcChanged.getNpc().getId() == this.npcID) {
            this.npcs.add(npcChanged.getNpc());
            this.npcInScene = true;
        }
    }

    @Override
    public void updateHandler() {
        this.npcInScene = false;
    }
}

