/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.conditional;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.ConditionForStep;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.runelite.api.Client;

public class Conditions
extends ConditionForStep {
    protected Operation operation;
    protected int quantity;
    protected String text;

    public Conditions(Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.logicType = LogicType.AND;
    }

    public Conditions(List<Requirement> conditions) {
        this.conditions = new ArrayList<Requirement>(conditions);
        this.logicType = LogicType.AND;
    }

    public Conditions(LogicType logicType, Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.logicType = logicType;
    }

    public Conditions(Operation operation, int quantity, Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.logicType = LogicType.AND;
        this.operation = operation;
        this.quantity = quantity;
    }

    public Conditions(LogicType logicType, List<Requirement> conditions) {
        this.conditions = new ArrayList<Requirement>(conditions);
        this.logicType = logicType;
    }

    public Conditions(boolean onlyNeedToPassOnce, Operation operation, int quantity, Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.onlyNeedToPassOnce = onlyNeedToPassOnce;
        this.logicType = LogicType.AND;
        this.operation = operation;
        this.quantity = quantity;
    }

    public Conditions(boolean onlyNeedToPassOnce, LogicType logicType, Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.onlyNeedToPassOnce = onlyNeedToPassOnce;
        this.logicType = logicType;
    }

    public Conditions(boolean onlyNeedToPassOnce, Requirement ... conditions) {
        this.conditions = new ArrayList();
        Collections.addAll(this.conditions, conditions);
        this.onlyNeedToPassOnce = onlyNeedToPassOnce;
        this.logicType = LogicType.AND;
    }

    @Override
    @Nonnull
    public String getDisplayText() {
        return this.text;
    }

    @Override
    public boolean check(Client client) {
        if (this.onlyNeedToPassOnce && this.hasPassed) {
            return true;
        }
        int conditionsPassed = (int)this.conditions.stream().filter(c -> {
            if (c == null) {
                return true;
            }
            return c.check(client);
        }).count();
        if (this.operation != null) {
            return this.operation.check(conditionsPassed, this.quantity);
        }
        if (conditionsPassed > 0 && this.logicType == LogicType.OR || conditionsPassed == 0 && this.logicType == LogicType.NOR || conditionsPassed == this.conditions.size() && this.logicType == LogicType.AND || conditionsPassed < this.conditions.size() && this.logicType == LogicType.NAND) {
            this.hasPassed = true;
            return true;
        }
        return false;
    }

    public void setText(String text) {
        this.text = text;
    }
}

