/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements;

import com.questhelper.QuestHelperConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.overlay.components.LineComponent;

public interface Requirement {
    public boolean check(Client var1);

    default public boolean checkWithConfigChange(Client client, ConfigManager configManager, String configName, String value) {
        if (this.check(client)) {
            configManager.setRSProfileConfiguration("questhelper", configName, (Object)value);
            return true;
        }
        return false;
    }

    default public boolean shouldConsiderForFilter() {
        return false;
    }

    @Nonnull
    public String getDisplayText();

    default public Color getColor(Client client, QuestHelperConfig config) {
        return this.check(client) ? config.passColour() : config.failColour();
    }

    @Nullable
    default public String getTooltip() {
        return null;
    }

    default public void setTooltip(@Nullable String tooltip) {
    }

    @Nullable
    default public String getUrlSuffix() {
        return null;
    }

    default public void setUrlSuffix(@Nullable String urlSuffix) {
    }

    default public List<LineComponent> getDisplayTextWithChecks(Client client, QuestHelperConfig config) {
        ArrayList<LineComponent> lines = new ArrayList<LineComponent>();
        if (!this.shouldDisplayText(client)) {
            return lines;
        }
        String text = this.getDisplayText();
        Color color = this.getColor(client, config);
        lines.add(LineComponent.builder().left(text).leftColor(color).build());
        return lines;
    }

    default public Requirement getOverlayReplacement() {
        return null;
    }

    default public boolean shouldDisplayText(Client client) {
        return true;
    }

    default public void setOverlayReplacement(Requirement requirement) {
    }
}

