/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements;

import com.questhelper.requirements.ChatMessageRequirement;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;

public class MesBoxRequirement
extends ChatMessageRequirement {
    public MesBoxRequirement(String ... text) {
        super(text);
    }

    @Override
    public void validateCondition(Client client, ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.MESBOX) {
            return;
        }
        if (!this.hasReceivedChatMessage) {
            this.hasReceivedChatMessage = this.isCurrentDialogMatching(chatMessage.getMessage());
        }
        if (!this.hasReceivedChatMessage) {
            if (this.messages.contains(chatMessage.getMessage()) && (this.condition == null || this.condition.check(client))) {
                this.hasReceivedChatMessage = true;
            }
        } else if (this.invalidateRequirement != null) {
            this.invalidateRequirement.validateCondition(client, chatMessage);
            if (this.invalidateRequirement.check(client)) {
                this.invalidateRequirement.setHasReceivedChatMessage(false);
                this.setHasReceivedChatMessage(false);
            }
        }
    }

    private boolean isCurrentDialogMatching(String dialogMessage) {
        return this.messages.stream().anyMatch(dialogMessage::contains);
    }
}

