/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.util.LogicType;
import java.util.stream.Stream;
import net.runelite.api.Client;

public class ComplexRequirement
extends AbstractRequirement {
    private final Requirement[] requirements;
    private final LogicType logicType;
    private final String name;

    public ComplexRequirement(String name, AbstractRequirement ... requirements) {
        this.name = name;
        this.requirements = requirements;
        this.logicType = LogicType.AND;
        this.shouldCountForFilter = true;
        for (AbstractRequirement requirement : requirements) {
            if (requirement.shouldConsiderForFilter()) continue;
            this.shouldCountForFilter = false;
            break;
        }
    }

    public ComplexRequirement(LogicType logicType, String name, Requirement ... requirements) {
        this.name = name;
        this.requirements = requirements;
        this.logicType = logicType;
    }

    @Override
    public boolean check(Client client) {
        if (this.logicType == null) {
            return false;
        }
        return this.logicType.test(Stream.of(this.requirements), r -> r.check(client));
    }

    @Override
    public String getDisplayText() {
        return this.name;
    }

    public Requirement[] getRequirements() {
        return this.requirements;
    }

    public LogicType getLogicType() {
        return this.logicType;
    }

    public String getName() {
        return this.name;
    }
}

