/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.ConditionForStep;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;

public class ChatMessageRequirement
extends ConditionForStep {
    protected boolean hasReceivedChatMessage = false;
    protected Requirement condition;
    protected ChatMessageRequirement invalidateRequirement;
    protected final List<String> messages;

    public ChatMessageRequirement(String ... message) {
        this.messages = Arrays.asList(message);
    }

    public ChatMessageRequirement(Requirement condition, String ... message) {
        this.condition = condition;
        this.messages = Arrays.asList(message);
    }

    @Override
    public boolean check(Client client) {
        return this.hasReceivedChatMessage;
    }

    public void validateCondition(Client client, ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() == ChatMessageType.ENGINE) {
            return;
        }
        if (!this.hasReceivedChatMessage) {
            if (this.messages.contains(chatMessage.getMessage()) && (this.condition == null || this.condition.check(client))) {
                this.hasReceivedChatMessage = true;
            }
        } else if (this.invalidateRequirement != null) {
            this.invalidateRequirement.validateCondition(client, chatMessage);
            if (this.invalidateRequirement.check(client)) {
                this.invalidateRequirement.setHasReceivedChatMessage(false);
                this.setHasReceivedChatMessage(false);
            }
        }
    }

    public void setHasReceivedChatMessage(boolean hasReceivedChatMessage) {
        this.hasReceivedChatMessage = hasReceivedChatMessage;
    }

    public void setInvalidateRequirement(ChatMessageRequirement invalidateRequirement) {
        this.invalidateRequirement = invalidateRequirement;
    }
}

