/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements;

import com.questhelper.QuestHelperConfig;
import com.questhelper.requirements.Requirement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.components.LineComponent;

public abstract class AbstractRequirement
implements Requirement {
    private String tooltip;
    private String urlSuffix;
    private Requirement panelReplacement = null;
    protected boolean shouldCountForFilter = false;

    @Override
    public abstract boolean check(Client var1);

    @Override
    public boolean shouldConsiderForFilter() {
        return this.shouldCountForFilter;
    }

    @Override
    public abstract String getDisplayText();

    @Override
    @Nullable
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    @Nullable
    public String getUrlSuffix() {
        return this.urlSuffix;
    }

    @Override
    public void setUrlSuffix(String urlSuffix) {
        this.urlSuffix = urlSuffix;
    }

    @Override
    public List<LineComponent> getDisplayTextWithChecks(Client client, QuestHelperConfig config) {
        if (this.getOverlayReplacement() != null && !this.check(client)) {
            return this.getOverlayReplacement().getDisplayTextWithChecks(client, config);
        }
        return this.getOverlayDisplayText(client, config);
    }

    protected List<LineComponent> getOverlayDisplayText(Client client, QuestHelperConfig config) {
        if (!this.shouldDisplayText(client)) {
            return new ArrayList<LineComponent>();
        }
        return Requirement.super.getDisplayTextWithChecks(client, config);
    }

    public void appendToTooltip(String text) {
        StringBuilder builder = new StringBuilder();
        String currentTooltip = this.getTooltip();
        if (currentTooltip != null) {
            builder.append(currentTooltip);
            builder.append(currentTooltip.isEmpty() ? "" : "\n");
        }
        if (text != null) {
            builder.append(text);
        }
        this.tooltip = builder.toString();
    }

    @Override
    public Requirement getOverlayReplacement() {
        return this.panelReplacement;
    }

    @Override
    public void setOverlayReplacement(Requirement panelReplacement) {
        this.panelReplacement = panelReplacement;
    }
}

