/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.questhelpers;

import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.bank.QuestBank;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestDebugRenderer;
import com.questhelper.questinfo.ExternalQuestResources;
import com.questhelper.questinfo.HelperConfig;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public abstract class QuestHelper
implements Module,
QuestDebugRenderer {
    @Inject
    protected Client client;
    @Inject
    protected ConfigManager configManager;
    @Inject
    protected RuneliteObjectManager runeliteObjectManager;
    @Inject
    protected QuestBank questBank;
    protected QuestHelperConfig config;
    @Inject
    private EventBus eventBus;
    private QuestStep currentStep;
    private QuestHelperQuest quest;
    private Injector injector;
    protected QuestHelperPlugin questHelperPlugin;

    public void configure(Binder binder) {
    }

    public abstract void init();

    public abstract void startUp(QuestHelperConfig var1);

    public void shutDown() {
        this.removeRuneliteObjects();
    }

    public void removeRuneliteObjects() {
        this.runeliteObjectManager.removeGroupAndSubgroups(this.toString());
    }

    public abstract boolean updateQuest();

    public void debugStartup(QuestHelperConfig config) {
    }

    protected void startUpStep(QuestStep step) {
        if (step != null) {
            this.currentStep = step;
            this.currentStep.startUp();
            this.eventBus.register((Object)this.currentStep);
        } else {
            this.currentStep = null;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    protected void instantiateSteps(Collection<QuestStep> steps) {
        for (QuestStep step : steps) {
            this.instantiateStep(step);
            if (!(step instanceof OwnerStep)) continue;
            this.instantiateSteps(((OwnerStep)((Object)step)).getSteps());
        }
    }

    public void instantiateStep(QuestStep questStep) {
        try {
            if (questStep != null) {
                this.injector.injectMembers((Object)questStep);
            }
        }
        catch (CreationException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCompleted() {
        return this.getState(this.client) == QuestState.FINISHED;
    }

    public QuestState getState(Client client) {
        return this.quest.getState(client, this.configManager);
    }

    public boolean clientMeetsRequirements() {
        if (this.getGeneralRequirements() == null) {
            return true;
        }
        return this.getGeneralRequirements().stream().filter(Objects::nonNull).allMatch(r -> !r.shouldConsiderForFilter() || r.check(this.client));
    }

    @Override
    public void renderDebugOverlay(Graphics graphics, QuestHelperPlugin plugin, PanelComponent panelComponent) {
        if (!plugin.isDeveloperMode()) {
            return;
        }
        panelComponent.getChildren().add(LineComponent.builder().left("Quest").leftColor(ColorScheme.BRAND_ORANGE_TRANSPARENT).right("Var").rightColor(ColorScheme.BRAND_ORANGE_TRANSPARENT).build());
        panelComponent.getChildren().add(LineComponent.builder().left(this.getQuest().getName()).leftColor(this.getConfig().debugColor()).right("" + this.getVar()).rightColor(this.getConfig().debugColor()).build());
    }

    public int getVar() {
        return this.quest.getVar(this.client);
    }

    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public abstract void setupRequirements();

    public List<ItemRequirement> getItemRequirements() {
        return null;
    }

    public List<Requirement> getGeneralRequirements() {
        return null;
    }

    public List<ItemRequirement> getItemRecommended() {
        return null;
    }

    public List<Requirement> getGeneralRecommended() {
        return null;
    }

    public List<String> getCombatRequirements() {
        return null;
    }

    public List<String> getNotes() {
        return null;
    }

    public QuestPointReward getQuestPointReward() {
        return null;
    }

    public List<ItemReward> getItemRewards() {
        return null;
    }

    public List<ExperienceReward> getExperienceRewards() {
        return null;
    }

    public List<UnlockReward> getUnlockRewards() {
        return null;
    }

    public List<String> getQuestRewards() {
        List<UnlockReward> unlockRewards;
        List<ExperienceReward> experienceReward;
        List<ItemReward> itemRewards;
        ArrayList<String> rewards = new ArrayList<String>();
        QuestPointReward questPointReward = this.getQuestPointReward();
        if (questPointReward != null) {
            rewards.add(questPointReward.getDisplayText());
            rewards.add("</br>");
        }
        if ((itemRewards = this.getItemRewards()) != null) {
            itemRewards.forEach(itemReward -> rewards.add(itemReward.getDisplayText()));
            rewards.add("</br>");
        }
        if ((experienceReward = this.getExperienceRewards()) != null) {
            experienceReward.forEach(expReward -> rewards.add(expReward.getDisplayText()));
            rewards.add("</br>");
        }
        if ((unlockRewards = this.getUnlockRewards()) != null) {
            unlockRewards.forEach(unlockReward -> rewards.add(unlockReward.getDisplayText()));
            rewards.add("</br>");
        }
        return rewards;
    }

    public List<ExternalQuestResources> getExternalResources() {
        return null;
    }

    public List<HelperConfig> getConfigs() {
        return null;
    }

    public abstract List<PanelDetails> getPanels();

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public QuestHelperConfig getConfig() {
        return this.config;
    }

    public void setConfig(QuestHelperConfig config) {
        this.config = config;
    }

    public QuestStep getCurrentStep() {
        return this.currentStep;
    }

    public QuestHelperQuest getQuest() {
        return this.quest;
    }

    public void setQuest(QuestHelperQuest quest) {
        this.quest = quest;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setQuestHelperPlugin(QuestHelperPlugin questHelperPlugin) {
        this.questHelperPlugin = questHelperPlugin;
    }

    public QuestHelperPlugin getQuestHelperPlugin() {
        return this.questHelperPlugin;
    }
}

