/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.questhelpers;

import com.questhelper.QuestHelperConfig;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BasicQuestHelper
extends QuestHelper {
    protected Map<Integer, QuestStep> steps;
    protected int var;

    @Override
    public void init() {
        if (this.steps == null) {
            this.steps = this.loadSteps();
        }
    }

    @Override
    public void startUp(QuestHelperConfig config) {
        this.steps = this.loadSteps();
        this.config = config;
        this.instantiateSteps(this.steps.values());
        this.var = this.getVar();
        this.startUpStep(this.steps.get(this.var));
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.shutDownStep();
    }

    @Override
    public boolean updateQuest() {
        if (this.var < this.getVar()) {
            this.var = this.getVar();
            this.shutDownStep();
            this.startUpStep(this.steps.get(this.var));
            return true;
        }
        return false;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> panelSteps = new ArrayList<PanelDetails>();
        this.steps.forEach((id, step) -> panelSteps.add(new PanelDetails("", (QuestStep)step)));
        return panelSteps;
    }

    public abstract Map<Integer, QuestStep> loadSteps();
}

