/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.playerquests.cookshelper;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.PlayerMadeQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.runelite.PlayerQuestStateRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.runeliteobjects.RuneliteConfigSetter;
import com.questhelper.runeliteobjects.dialog.RuneliteObjectDialogStep;
import com.questhelper.runeliteobjects.dialog.RunelitePlayerDialogStep;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FaceAnimationIDs;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeItem;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeNpc;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ReplacedObject;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import com.questhelper.steps.playermadesteps.RuneliteObjectStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.COOKS_HELPER)
public class CooksHelper
extends PlayerMadeQuestHelper {
    private RuneliteObjectStep talkToCook;
    private RuneliteObjectStep talkToHopleez;
    private RuneliteObjectStep grabCabbage;
    private RuneliteObjectStep returnToHopleez;
    private DetailedQuestStep standNextToCook;
    private DetailedQuestStep standNextToHopleez;
    private DetailedQuestStep standNextToHopleez2;
    private Requirement nearCook;
    private Requirement nearHopleez;
    private FakeNpc cooksCousin;
    private FakeNpc hopleez;
    private FakeItem cabbage;
    private PlayerQuestStateRequirement talkedToCooksCousin;
    private PlayerQuestStateRequirement talkedToHopleez;
    private PlayerQuestStateRequirement displayCabbage;
    private PlayerQuestStateRequirement pickedCabbage;

    @Override
    public QuestStep loadStep() {
        this.itemWidget = 12432;
        this.rotationX = 100;
        this.zoom = 200;
        this.setupRequirements();
        this.createRuneliteObjects();
        this.setupSteps();
        PlayerQuestStateRequirement req = new PlayerQuestStateRequirement(this.configManager, this.getQuest().getPlayerQuests(), 0);
        ConditionalStep questSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.standNextToCook, new Requirement[0]);
        questSteps.addStep(req.getNewState(4), new DetailedQuestStep((QuestHelper)this, "Quest completed!", new Requirement[0]));
        questSteps.addStep(new Conditions(req.getNewState(3), this.nearHopleez), this.returnToHopleez);
        questSteps.addStep(req.getNewState(3), this.standNextToHopleez2);
        questSteps.addStep(req.getNewState(2), this.grabCabbage);
        questSteps.addStep(new Conditions(req.getNewState(1), this.nearHopleez), this.talkToHopleez);
        questSteps.addStep(req.getNewState(1), this.standNextToHopleez);
        questSteps.addStep(this.nearCook, this.talkToCook);
        return questSteps;
    }

    @Override
    public void setupRequirements() {
        this.talkedToCooksCousin = new PlayerQuestStateRequirement(this.configManager, this.getQuest().getPlayerQuests(), 1, Operation.GREATER_EQUAL);
        this.talkedToHopleez = new PlayerQuestStateRequirement(this.configManager, this.getQuest().getPlayerQuests(), 2, Operation.GREATER_EQUAL);
        this.pickedCabbage = new PlayerQuestStateRequirement(this.configManager, this.getQuest().getPlayerQuests(), 3, Operation.GREATER_EQUAL);
        this.displayCabbage = new PlayerQuestStateRequirement(this.configManager, this.getQuest().getPlayerQuests(), 2);
        this.nearCook = new ZoneRequirement(new Zone(new WorldPoint(3206, 3212, 0), new WorldPoint(3212, 3218, 0)));
        this.nearHopleez = new ZoneRequirement(new Zone(new WorldPoint(3232, 3212, 0), new WorldPoint(3238, 3218, 0)));
    }

    public void setupSteps() {
        this.talkToCook = new RuneliteObjectStep((QuestHelper)this, this.cooksCousin, "Talk to the Lumbridge Cook's Cousin.", new Requirement[0]);
        this.standNextToCook = new TileStep((QuestHelper)this, new WorldPoint(3210, 3215, 0), "Talk to the Lumbridge Cook's Cousin.", new Requirement[0]);
        this.talkToCook.addSubSteps(this.standNextToCook);
        this.talkToHopleez = new RuneliteObjectStep((QuestHelper)this, this.hopleez, "Talk to Hopleez east of Lumbridge Castle.", new Requirement[0]);
        this.standNextToHopleez = new TileStep((QuestHelper)this, new WorldPoint(3236, 3215, 0), "Talk to Hopleez east of Lumbridge Castle.", new Requirement[0]);
        this.talkToHopleez.addSubSteps(this.standNextToHopleez);
        this.grabCabbage = new RuneliteObjectStep((QuestHelper)this, this.cabbage, "Get the cabbage to the north of Hopleez, outside the Sheared Ram.", new Requirement[0]);
        this.returnToHopleez = new RuneliteObjectStep((QuestHelper)this, this.hopleez, "Return to Hopleez east of Lumbridge Castle.", new Requirement[0]);
        this.standNextToHopleez2 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3235, 3216, 0), "Return to Hopleez east of Lumbridge Castle.", new Requirement[0]);
        this.returnToHopleez.addSubSteps(this.standNextToHopleez2);
    }

    private void setupCooksCousin() {
        this.cooksCousin = this.runeliteObjectManager.createFakeNpc(this.toString(), this.client.getNpcDefinition(4626).getModels(), new WorldPoint(3209, 3215, 0), 808);
        this.cooksCousin.setName("Cook's Cousin");
        this.cooksCousin.setFace(4626);
        this.cooksCousin.setExamine("The Cook's cousin.");
        this.cooksCousin.addTalkAction(this.runeliteObjectManager);
        this.cooksCousin.addExamineAction(this.runeliteObjectManager);
        QuestRequirement hasDoneCooksAssistant = new QuestRequirement(QuestHelperQuest.COOKS_ASSISTANT, QuestState.FINISHED);
        RuneliteObjectDialogStep dontMeetReqDialog = this.cooksCousin.createDialogStepForNpc("Come talk to me once you've helped my cousin out.");
        this.cooksCousin.addDialogTree(null, dontMeetReqDialog);
        RuneliteObjectDialogStep dialog = this.cooksCousin.createDialogStepForNpc("Hey, you there! You helped out my cousin before right?");
        dialog.addContinueDialog(new RunelitePlayerDialogStep(this.client, "I have yeah, what's wrong? Does he need some more eggs? Maybe I can just get him a chicken instead?")).addContinueDialog(this.cooksCousin.createDialogStepForNpc("No no, nothing like that. Have you seen that terribly dressed person outside the courtyard?", FaceAnimationIDs.FRIENDLY_QUESTIONING)).addContinueDialog(this.cooksCousin.createDialogStepForNpc("I don't know who they are, but can you please get them to move along please?", FaceAnimationIDs.FRIENDLY_QUESTIONING)).addContinueDialog(this.cooksCousin.createDialogStepForNpc("They seem to be attracting more troublemakers....")).addContinueDialog(new RunelitePlayerDialogStep(this.client, "You mean Hatius? If so it'd be my pleasure.").setStateProgression(this.talkedToCooksCousin.getSetter()));
        this.cooksCousin.addDialogTree(hasDoneCooksAssistant, dialog);
        RuneliteObjectDialogStep dialogV2 = this.cooksCousin.createDialogStepForNpc("That terribly dressed person is still outside the castle, go talk to them!");
        this.cooksCousin.addDialogTree(this.talkedToCooksCousin, dialogV2);
    }

    private void setupHopleez() {
        this.hopleez = this.runeliteObjectManager.createFakeNpc(this.toString(), this.client.getNpcDefinition(7481).getModels(), new WorldPoint(3235, 3215, 0), 808);
        this.hopleez.setName("Hopleez");
        this.hopleez.setFace(7481);
        this.hopleez.setExamine("He was here first.");
        this.hopleez.addTalkAction(this.runeliteObjectManager);
        this.hopleez.addExamineAction(this.runeliteObjectManager);
        RuneliteObjectDialogStep hopleezDialogPreQuest = this.hopleez.createDialogStepForNpc("Hop noob.");
        hopleezDialogPreQuest.addContinueDialog(new RunelitePlayerDialogStep(this.client, "What? Also, what are you wearing?")).addContinueDialog(this.hopleez.createDialogStepForNpc("Hop NOOB."));
        this.hopleez.addDialogTree(null, hopleezDialogPreQuest);
        RuneliteObjectDialogStep hopleezDialog1 = this.hopleez.createDialogStepForNpc("Hop noob.", FaceAnimationIDs.ANNOYED);
        hopleezDialog1.addContinueDialog(new RunelitePlayerDialogStep(this.client, "What? The Cook's Cousin sent me to see what you were doing here.", FaceAnimationIDs.QUIZZICAL)).addContinueDialog(this.hopleez.createDialogStepForNpc("One moment I was relaxing in Zeah killing some crabs. I closed my eyes for a second, and suddenly I'm here.")).addContinueDialog(this.hopleez.createDialogStepForNpc("People would always try to steal my spot in Zeah, and it seems it's no different here!", FaceAnimationIDs.ANNOYED)).addContinueDialog(this.hopleez.createDialogStepForNpc("Not only is this guy crashing me, but he's trying to outdress me too!", FaceAnimationIDs.ANNOYED_2)).addContinueDialog(new RunelitePlayerDialogStep(this.client, "Hatius? I'm pretty sure he's been here much longer than you....", FaceAnimationIDs.QUESTIONING)).addContinueDialog(this.hopleez.createDialogStepForNpc("I swear he wasn't here when I first arrived, I went away for a second and suddenly he's here!", FaceAnimationIDs.ANNOYED_2)).addContinueDialog(this.hopleez.createDialogStepForNpc("Help me teach him a lesson, get me that old cabbage from outside the The Sheared Ram.")).addContinueDialog(new RunelitePlayerDialogStep(this.client, "Umm, sure....", this.talkedToHopleez.getSetter()));
        this.hopleez.addDialogTree(this.talkedToCooksCousin, hopleezDialog1);
        RuneliteObjectDialogStep hopleezWaitingForCabbageDialog = this.hopleez.createDialogStepForNpc("Get me that cabbage!");
        this.hopleez.addDialogTree(this.talkedToHopleez, hopleezWaitingForCabbageDialog);
        RuneliteConfigSetter endQuest = new RuneliteConfigSetter(this.configManager, this.getQuest().getPlayerQuests().getConfigValue(), "4");
        RuneliteObjectDialogStep hopleezGiveCabbageDialog = this.hopleez.createDialogStepForNpc("Have you got the cabbage?");
        hopleezGiveCabbageDialog.addContinueDialog(new RunelitePlayerDialogStep(this.client, "I have! Here you go, why do you need it?")).addContinueDialog(this.hopleez.createDialogStepForNpc("Nice! Now let's sort out this crasher...")).addContinueDialog(this.hopleez.createDialogStepForNpc("Oi noob, take this!")).addContinueDialog(new RuneliteObjectDialogStep("Hatius Cosaintus", "What on earth?", 5523).setStateProgression(endQuest));
        this.hopleez.addDialogTree(this.pickedCabbage, hopleezGiveCabbageDialog);
    }

    private void setupCabbage() {
        this.cabbage = this.runeliteObjectManager.createFakeItem(this.toString(), new int[]{8196}, new WorldPoint(3231, 3235, 0), -1);
        this.cabbage.setName("Old cabbage");
        this.cabbage.setExamine("A mouldy looking cabbage.");
        this.cabbage.addExamineAction(this.runeliteObjectManager);
        this.cabbage.setDisplayRequirement(this.displayCabbage);
        this.cabbage.addTakeAction(this.runeliteObjectManager, new RuneliteConfigSetter(this.configManager, this.getQuest().getPlayerQuests().getConfigValue(), "3"), "You pick up the old cabbage.");
        this.cabbage.setObjectToRemove(new ReplacedObject(37348, new WorldPoint(3231, 3235, 0)));
    }

    private void createRuneliteObjects() {
        this.setupCooksCousin();
        this.setupHopleez();
        this.setupCabbage();
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestRequirement(QuestHelperQuest.COOKS_ASSISTANT, QuestState.FINISHED));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("A replacement for Hatius Cosaintus"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails helpingTheCousinSteps = new PanelDetails("Helping the Cook's Cousin", Arrays.asList(this.talkToCook, this.talkToHopleez, this.grabCabbage, this.returnToHopleez), new Requirement[0]);
        allSteps.add(helpingTheCousinSteps);
        return allSteps;
    }
}

