/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel.questorders;

import com.google.common.collect.ImmutableList;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class QuestOrders {
    private static final Pattern QUEST_NAME_PATTERN = Pattern.compile("(?i)(a\\b)|(the\\b)|(an\\b)", 2);
    private static final List<QuestHelperQuest> optimalOrder = ImmutableList.of((Object)((Object)QuestHelperQuest.COOKS_ASSISTANT), (Object)((Object)QuestHelperQuest.SHEEP_SHEARER), (Object)((Object)QuestHelperQuest.MISTHALIN_MYSTERY), (Object)((Object)QuestHelperQuest.PRINCE_ALI_RESCUE), (Object)((Object)QuestHelperQuest.THE_RESTLESS_GHOST), (Object)((Object)QuestHelperQuest.RUNE_MYSTERIES), (Object)((Object)QuestHelperQuest.IMP_CATCHER), (Object)((Object)QuestHelperQuest.WITCHS_POTION), (Object)((Object)QuestHelperQuest.GERTRUDES_CAT), (Object)((Object)QuestHelperQuest.DADDYS_HOME), (Object)((Object)QuestHelperQuest.DWARF_CANNON), (Object)((Object)QuestHelperQuest.WATERFALL_QUEST), (Object[])new QuestHelperQuest[]{QuestHelperQuest.TREE_GNOME_VILLAGE, QuestHelperQuest.FIGHT_ARENA, QuestHelperQuest.PLAGUE_CITY, QuestHelperQuest.MONKS_FRIEND, QuestHelperQuest.HAZEEL_CULT, QuestHelperQuest.SHEEP_HERDER, QuestHelperQuest.BIOHAZARD, QuestHelperQuest.TOWER_OF_LIFE, QuestHelperQuest.TRIBAL_TOTEM, QuestHelperQuest.DRUIDIC_RITUAL, QuestHelperQuest.WITCHS_HOUSE, QuestHelperQuest.DEATH_PLATEAU, QuestHelperQuest.MERLINS_CRYSTAL, QuestHelperQuest.HOLY_GRAIL, QuestHelperQuest.MURDER_MYSTERY, QuestHelperQuest.THE_KNIGHTS_SWORD, QuestHelperQuest.SLEEPING_GIANTS, QuestHelperQuest.THE_TOURIST_TRAP, QuestHelperQuest.THE_GRAND_TREE, QuestHelperQuest.ARDOUGNE_EASY, QuestHelperQuest.RAG_AND_BONE_MAN_I, QuestHelperQuest.PRIEST_IN_PERIL, QuestHelperQuest.NATURE_SPIRIT, QuestHelperQuest.MAKING_HISTORY, QuestHelperQuest.MOUNTAIN_DAUGHTER, QuestHelperQuest.DORICS_QUEST, QuestHelperQuest.BLACK_KNIGHTS_FORTRESS, QuestHelperQuest.RECRUITMENT_DRIVE, QuestHelperQuest.GOBLIN_DIPLOMACY, QuestHelperQuest.RECIPE_FOR_DISASTER_START, QuestHelperQuest.RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE, QuestHelperQuest.THE_LOST_TRIBE, QuestHelperQuest.DEATH_TO_THE_DORGESHUUN, QuestHelperQuest.ELEMENTAL_WORKSHOP_I, QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestHelperQuest.THE_GOLEM, QuestHelperQuest.THE_FEUD, QuestHelperQuest.LOST_CITY, QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS, QuestHelperQuest.RATCATCHERS, QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestHelperQuest.SCORPION_CATCHER, QuestHelperQuest.THE_DIG_SITE, QuestHelperQuest.ELEMENTAL_WORKSHOP_II, QuestHelperQuest.A_SOULS_BANE, QuestHelperQuest.ENTER_THE_ABYSS, QuestHelperQuest.X_MARKS_THE_SPOT, QuestHelperQuest.PIRATES_TREASURE, QuestHelperQuest.CLIENT_OF_KOUREND, QuestHelperQuest.THE_QUEEN_OF_THIEVES, QuestHelperQuest.THE_DEPTHS_OF_DESPAIR, QuestHelperQuest.A_PORCINE_OF_INTEREST, QuestHelperQuest.SEA_SLUG, QuestHelperQuest.FISHING_CONTEST, QuestHelperQuest.RECIPE_FOR_DISASTER_DWARF, QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG, QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG, QuestHelperQuest.BONE_VOYAGE, QuestHelperQuest.WATCHTOWER, QuestHelperQuest.THE_GIANT_DWARF, QuestHelperQuest.FORGETTABLE_TALE, QuestHelperQuest.ANOTHER_SLICE_OF_HAM, QuestHelperQuest.VAMPYRE_SLAYER, QuestHelperQuest.ERNEST_THE_CHICKEN, QuestHelperQuest.WANTED, QuestHelperQuest.GHOSTS_AHOY, QuestHelperQuest.DEMON_SLAYER, QuestHelperQuest.SHADOW_OF_THE_STORM, QuestHelperQuest.ANIMAL_MAGNETISM, QuestHelperQuest.CREATURE_OF_FENKENSTRAIN, QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestHelperQuest.JUNGLE_POTION, QuestHelperQuest.SHILO_VILLAGE, QuestHelperQuest.KARAMJA_EASY, QuestHelperQuest.ZOGRE_FLESH_EATERS, QuestHelperQuest.OBSERVATORY_QUEST, QuestHelperQuest.HORROR_FROM_THE_DEEP, QuestHelperQuest.SPIRITS_OF_THE_ELID, QuestHelperQuest.GARDEN_OF_TRANQUILLITY, QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestHelperQuest.BALLOON_TRANSPORT_CRAFTING_GUILD, QuestHelperQuest.BALLOON_TRANSPORT_VARROCK, QuestHelperQuest.ROMEO__JULIET, QuestHelperQuest.TEARS_OF_GUTHIX, QuestHelperQuest.IN_SEARCH_OF_THE_MYREQUE, QuestHelperQuest.SHADES_OF_MORTTON, QuestHelperQuest.IN_AID_OF_THE_MYREQUE, QuestHelperQuest.SKIPPY_AND_THE_MOGRES, QuestHelperQuest.TROLL_STRONGHOLD, QuestHelperQuest.TROLL_ROMANCE, QuestHelperQuest.DARKNESS_OF_HALLOWVALE, QuestHelperQuest.UNDERGROUND_PASS, QuestHelperQuest.REGICIDE, QuestHelperQuest.DRAGON_SLAYER_I, QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestHelperQuest.THE_FREMENNIK_ISLES, QuestHelperQuest.RECIPE_FOR_DISASTER_EVIL_DAVE, QuestHelperQuest.RECIPE_FOR_DISASTER_PIRATE_PETE, QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestHelperQuest.KANDARIN_EASY, QuestHelperQuest.CONTACT, QuestHelperQuest.TEMPLE_OF_IKOV, QuestHelperQuest.THE_EYES_OF_GLOUPHRIE, QuestHelperQuest.TEMPLE_OF_THE_EYE, QuestHelperQuest.ONE_SMALL_FAVOUR, QuestHelperQuest.THE_ASCENT_OF_ARCEUUS, QuestHelperQuest.TALE_OF_THE_RIGHTEOUS, QuestHelperQuest.WILDERNESS_EASY, QuestHelperQuest.DESERT_EASY, QuestHelperQuest.FALADOR_EASY, QuestHelperQuest.LUMBRIDGE_EASY, QuestHelperQuest.MORYTANIA_EASY, QuestHelperQuest.VARROCK_EASY, QuestHelperQuest.FREMENNIK_EASY, QuestHelperQuest.KOUREND_EASY, QuestHelperQuest.WESTERN_EASY, QuestHelperQuest.BETWEEN_A_ROCK, QuestHelperQuest.THE_FORSAKEN_TOWER, QuestHelperQuest.ARCHITECTURAL_ALLIANCE, QuestHelperQuest.THE_SLUG_MENACE, QuestHelperQuest.GETTING_AHEAD, QuestHelperQuest.COLD_WAR, QuestHelperQuest.THE_HAND_IN_THE_SAND, QuestHelperQuest.ENAKHRAS_LAMENT, QuestHelperQuest.EADGARS_RUSE, QuestHelperQuest.MY_ARMS_BIG_ADVENTURE, QuestHelperQuest.THE_GARDEN_OF_DEATH, QuestHelperQuest.RAG_AND_BONE_MAN_II, QuestHelperQuest.RUM_DEAL, QuestHelperQuest.CABIN_FEVER, QuestHelperQuest.RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE, QuestHelperQuest.RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE, QuestHelperQuest.HEROES_QUEST, QuestHelperQuest.THRONE_OF_MISCELLANIA, QuestHelperQuest.ROYAL_TROUBLE, QuestHelperQuest.HAUNTED_MINE, QuestHelperQuest.LAIR_OF_TARN_RAZORLOR, QuestHelperQuest.MONKEY_MADNESS_I, QuestHelperQuest.ROVING_ELVES, QuestHelperQuest.MOURNINGS_END_PART_I, QuestHelperQuest.MOURNINGS_END_PART_II, QuestHelperQuest.DESERT_TREASURE, QuestHelperQuest.FAMILY_CREST, QuestHelperQuest.WHAT_LIES_BELOW, QuestHelperQuest.EAGLES_PEAK, QuestHelperQuest.A_TAIL_OF_TWO_CATS, QuestHelperQuest.LEGENDS_QUEST, QuestHelperQuest.LAND_OF_THE_GOBLINS, QuestHelperQuest.RECIPE_FOR_DISASTER_SIR_AMIK_VARZE, QuestHelperQuest.OLAFS_QUEST, QuestHelperQuest.A_KINGDOM_DIVIDED, QuestHelperQuest.A_TASTE_OF_HOPE, QuestHelperQuest.BALLOON_TRANSPORT_CASTLE_WARS, QuestHelperQuest.ARDOUGNE_MEDIUM, QuestHelperQuest.DESERT_MEDIUM, QuestHelperQuest.FALADOR_MEDIUM, QuestHelperQuest.FREMENNIK_MEDIUM, QuestHelperQuest.KANDARIN_MEDIUM, QuestHelperQuest.KOUREND_MEDIUM, QuestHelperQuest.LUMBRIDGE_MEDIUM, QuestHelperQuest.MORYTANIA_MEDIUM, QuestHelperQuest.VARROCK_MEDIUM, QuestHelperQuest.WESTERN_MEDIUM, QuestHelperQuest.CURSE_OF_THE_EMPTY_LORD, QuestHelperQuest.THE_GENERALS_SHADOW, QuestHelperQuest.HIS_FAITHFUL_SERVANTS, QuestHelperQuest.THE_GREAT_BRAIN_ROBBERY, QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestHelperQuest.RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR, QuestHelperQuest.RECIPE_FOR_DISASTER_FINALE, QuestHelperQuest.THE_PATH_OF_GLOUPHRIE, QuestHelperQuest.LUNAR_DIPLOMACY, QuestHelperQuest.KINGS_RANSOM, QuestHelperQuest.KNIGHT_WAVES_TRAINING_GROUNDS, QuestHelperQuest.SWAN_SONG, QuestHelperQuest.DEVIOUS_MINDS, QuestHelperQuest.GRIM_TALES, QuestHelperQuest.DREAM_MENTOR, QuestHelperQuest.KARAMJA_MEDIUM, QuestHelperQuest.WILDERNESS_MEDIUM, QuestHelperQuest.THE_FREMENNIK_EXILES, QuestHelperQuest.SINS_OF_THE_FATHER, QuestHelperQuest.BALLOON_TRANSPORT_GRAND_TREE, QuestHelperQuest.IN_SEARCH_OF_KNOWLEDGE, QuestHelperQuest.HOPESPEARS_WILL, QuestHelperQuest.BENEATH_CURSED_SANDS, QuestHelperQuest.MONKEY_MADNESS_II, QuestHelperQuest.A_NIGHT_AT_THE_THEATRE, QuestHelperQuest.DRAGON_SLAYER_II, QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestHelperQuest.SECRETS_OF_THE_NORTH, QuestHelperQuest.BELOW_ICE_MOUNTAIN, QuestHelperQuest.DESERT_TREASURE_II, QuestHelperQuest.SONG_OF_THE_ELVES, QuestHelperQuest.CLOCK_TOWER, QuestHelperQuest.THE_CORSAIR_CURSE, QuestHelperQuest.BEAR_YOUR_SOUL, QuestHelperQuest.ENCHANTED_KEY, QuestHelperQuest.FAMILY_PEST, QuestHelperQuest.THE_MAGE_ARENA, QuestHelperQuest.THE_MAGE_ARENA_II, QuestHelperQuest.ARDOUGNE_HARD, QuestHelperQuest.ARDOUGNE_ELITE, QuestHelperQuest.DESERT_HARD, QuestHelperQuest.DESERT_ELITE, QuestHelperQuest.FALADOR_HARD, QuestHelperQuest.FALADOR_ELITE, QuestHelperQuest.FREMENNIK_HARD, QuestHelperQuest.FREMENNIK_ELITE, QuestHelperQuest.KANDARIN_HARD, QuestHelperQuest.KANDARIN_ELITE, QuestHelperQuest.KARAMJA_HARD, QuestHelperQuest.KARAMJA_ELITE, QuestHelperQuest.KOUREND_HARD, QuestHelperQuest.KOUREND_ELITE, QuestHelperQuest.LUMBRIDGE_HARD, QuestHelperQuest.LUMBRIDGE_ELITE, QuestHelperQuest.MORYTANIA_HARD, QuestHelperQuest.MORYTANIA_ELITE, QuestHelperQuest.VARROCK_HARD, QuestHelperQuest.VARROCK_ELITE, QuestHelperQuest.WESTERN_HARD, QuestHelperQuest.WESTERN_ELITE, QuestHelperQuest.WILDERNESS_HARD, QuestHelperQuest.WILDERNESS_ELITE});
    private static final List<QuestHelperQuest> optimalIronmanOrder = ImmutableList.of((Object)((Object)QuestHelperQuest.COOKS_ASSISTANT), (Object)((Object)QuestHelperQuest.SHEEP_SHEARER), (Object)((Object)QuestHelperQuest.MISTHALIN_MYSTERY), (Object)((Object)QuestHelperQuest.THE_RESTLESS_GHOST), (Object)((Object)QuestHelperQuest.X_MARKS_THE_SPOT), (Object)((Object)QuestHelperQuest.WITCHS_POTION), (Object)((Object)QuestHelperQuest.IMP_CATCHER), (Object)((Object)QuestHelperQuest.CLIENT_OF_KOUREND), (Object)((Object)QuestHelperQuest.ROMEO__JULIET), (Object)((Object)QuestHelperQuest.GERTRUDES_CAT), (Object)((Object)QuestHelperQuest.DADDYS_HOME), (Object)((Object)QuestHelperQuest.RUNE_MYSTERIES), (Object[])new QuestHelperQuest[]{QuestHelperQuest.TREE_GNOME_VILLAGE, QuestHelperQuest.MONKS_FRIEND, QuestHelperQuest.HAZEEL_CULT, QuestHelperQuest.PLAGUE_CITY, QuestHelperQuest.BIOHAZARD, QuestHelperQuest.FIGHT_ARENA, QuestHelperQuest.CLOCK_TOWER, QuestHelperQuest.SHEEP_HERDER, QuestHelperQuest.DWARF_CANNON, QuestHelperQuest.WATERFALL_QUEST, QuestHelperQuest.MURDER_MYSTERY, QuestHelperQuest.MERLINS_CRYSTAL, QuestHelperQuest.HOLY_GRAIL, QuestHelperQuest.DRUIDIC_RITUAL, QuestHelperQuest.WITCHS_HOUSE, QuestHelperQuest.BELOW_ICE_MOUNTAIN, QuestHelperQuest.BLACK_KNIGHTS_FORTRESS, QuestHelperQuest.RECRUITMENT_DRIVE, QuestHelperQuest.OBSERVATORY_QUEST, QuestHelperQuest.PRIEST_IN_PERIL, QuestHelperQuest.RAG_AND_BONE_MAN_I, QuestHelperQuest.NATURE_SPIRIT, QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestHelperQuest.SCORPION_CATCHER, QuestHelperQuest.JUNGLE_POTION, QuestHelperQuest.VAMPYRE_SLAYER, QuestHelperQuest.A_PORCINE_OF_INTEREST, QuestHelperQuest.DEATH_PLATEAU, QuestHelperQuest.GOBLIN_DIPLOMACY, QuestHelperQuest.THE_QUEEN_OF_THIEVES, QuestHelperQuest.THE_DEPTHS_OF_DESPAIR, QuestHelperQuest.MOUNTAIN_DAUGHTER, QuestHelperQuest.THE_GRAND_TREE, QuestHelperQuest.TRIBAL_TOTEM, QuestHelperQuest.THE_DIG_SITE, QuestHelperQuest.THE_GOLEM, QuestHelperQuest.THE_KNIGHTS_SWORD, QuestHelperQuest.SLEEPING_GIANTS, QuestHelperQuest.ELEMENTAL_WORKSHOP_I, QuestHelperQuest.RECIPE_FOR_DISASTER_START, QuestHelperQuest.RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE, QuestHelperQuest.DEMON_SLAYER, QuestHelperQuest.SHADOW_OF_THE_STORM, QuestHelperQuest.ELEMENTAL_WORKSHOP_II, QuestHelperQuest.LOST_CITY, QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS, QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG, QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG, QuestHelperQuest.CREATURE_OF_FENKENSTRAIN, QuestHelperQuest.A_SOULS_BANE, QuestHelperQuest.THE_LOST_TRIBE, QuestHelperQuest.DEATH_TO_THE_DORGESHUUN, QuestHelperQuest.THE_GIANT_DWARF, QuestHelperQuest.ANOTHER_SLICE_OF_HAM, QuestHelperQuest.MAKING_HISTORY, QuestHelperQuest.IN_SEARCH_OF_THE_MYREQUE, QuestHelperQuest.SHADES_OF_MORTTON, QuestHelperQuest.IN_AID_OF_THE_MYREQUE, QuestHelperQuest.BONE_VOYAGE, QuestHelperQuest.ENTER_THE_ABYSS, QuestHelperQuest.WANTED, QuestHelperQuest.THE_FEUD, QuestHelperQuest.TROLL_STRONGHOLD, QuestHelperQuest.TROLL_ROMANCE, QuestHelperQuest.DRAGON_SLAYER_I, QuestHelperQuest.HORROR_FROM_THE_DEEP, QuestHelperQuest.ERNEST_THE_CHICKEN, QuestHelperQuest.ANIMAL_MAGNETISM, QuestHelperQuest.SHILO_VILLAGE, QuestHelperQuest.DORICS_QUEST, QuestHelperQuest.SPIRITS_OF_THE_ELID, QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestHelperQuest.RATCATCHERS, QuestHelperQuest.DARKNESS_OF_HALLOWVALE, QuestHelperQuest.TOWER_OF_LIFE, QuestHelperQuest.FISHING_CONTEST, QuestHelperQuest.RECIPE_FOR_DISASTER_DWARF, QuestHelperQuest.GHOSTS_AHOY, QuestHelperQuest.FORGETTABLE_TALE, QuestHelperQuest.GARDEN_OF_TRANQUILLITY, QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestHelperQuest.RECIPE_FOR_DISASTER_EVIL_DAVE, QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestHelperQuest.ZOGRE_FLESH_EATERS, QuestHelperQuest.RECIPE_FOR_DISASTER_PIRATE_PETE, QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestHelperQuest.THE_TOURIST_TRAP, QuestHelperQuest.EADGARS_RUSE, QuestHelperQuest.MY_ARMS_BIG_ADVENTURE, QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestHelperQuest.THE_FREMENNIK_ISLES, QuestHelperQuest.GETTING_AHEAD, QuestHelperQuest.RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE, QuestHelperQuest.RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE, QuestHelperQuest.HAUNTED_MINE, QuestHelperQuest.WATCHTOWER, QuestHelperQuest.PRINCE_ALI_RESCUE, QuestHelperQuest.CONTACT, QuestHelperQuest.THE_EYES_OF_GLOUPHRIE, QuestHelperQuest.TEMPLE_OF_THE_EYE, QuestHelperQuest.SEA_SLUG, QuestHelperQuest.OLAFS_QUEST, QuestHelperQuest.TEARS_OF_GUTHIX, QuestHelperQuest.TEMPLE_OF_IKOV, QuestHelperQuest.ONE_SMALL_FAVOUR, QuestHelperQuest.A_TAIL_OF_TWO_CATS, QuestHelperQuest.THE_SLUG_MENACE, QuestHelperQuest.BETWEEN_A_ROCK, QuestHelperQuest.MONKEY_MADNESS_I, QuestHelperQuest.COLD_WAR, QuestHelperQuest.THE_ASCENT_OF_ARCEUUS, QuestHelperQuest.EAGLES_PEAK, QuestHelperQuest.UNDERGROUND_PASS, QuestHelperQuest.SKIPPY_AND_THE_MOGRES, QuestHelperQuest.RAG_AND_BONE_MAN_II, QuestHelperQuest.LAIR_OF_TARN_RAZORLOR, QuestHelperQuest.RUM_DEAL, QuestHelperQuest.PIRATES_TREASURE, QuestHelperQuest.CABIN_FEVER, QuestHelperQuest.THE_GREAT_BRAIN_ROBBERY, QuestHelperQuest.THE_HAND_IN_THE_SAND, QuestHelperQuest.ENAKHRAS_LAMENT, QuestHelperQuest.HEROES_QUEST, QuestHelperQuest.THRONE_OF_MISCELLANIA, QuestHelperQuest.ROYAL_TROUBLE, QuestHelperQuest.DESERT_TREASURE, QuestHelperQuest.CURSE_OF_THE_EMPTY_LORD, QuestHelperQuest.THE_GENERALS_SHADOW, QuestHelperQuest.HIS_FAITHFUL_SERVANTS, QuestHelperQuest.A_TASTE_OF_HOPE, QuestHelperQuest.FAMILY_CREST, QuestHelperQuest.LEGENDS_QUEST, QuestHelperQuest.RECIPE_FOR_DISASTER_SIR_AMIK_VARZE, QuestHelperQuest.KARAMJA_EASY, QuestHelperQuest.KANDARIN_EASY, QuestHelperQuest.FALADOR_EASY, QuestHelperQuest.VARROCK_EASY, QuestHelperQuest.FREMENNIK_EASY, QuestHelperQuest.WILDERNESS_EASY, QuestHelperQuest.DESERT_EASY, QuestHelperQuest.ARDOUGNE_EASY, QuestHelperQuest.LUMBRIDGE_EASY, QuestHelperQuest.MORYTANIA_EASY, QuestHelperQuest.KOUREND_EASY, QuestHelperQuest.WESTERN_EASY, QuestHelperQuest.ARDOUGNE_MEDIUM, QuestHelperQuest.FALADOR_MEDIUM, QuestHelperQuest.VARROCK_MEDIUM, QuestHelperQuest.KANDARIN_MEDIUM, QuestHelperQuest.LAND_OF_THE_GOBLINS, QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestHelperQuest.TALE_OF_THE_RIGHTEOUS, QuestHelperQuest.THE_FORSAKEN_TOWER, QuestHelperQuest.ARCHITECTURAL_ALLIANCE, QuestHelperQuest.A_KINGDOM_DIVIDED, QuestHelperQuest.RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR, QuestHelperQuest.REGICIDE, QuestHelperQuest.ROVING_ELVES, QuestHelperQuest.MOURNINGS_END_PART_I, QuestHelperQuest.MOURNINGS_END_PART_II, QuestHelperQuest.LUNAR_DIPLOMACY, QuestHelperQuest.WHAT_LIES_BELOW, QuestHelperQuest.KINGS_RANSOM, QuestHelperQuest.KNIGHT_WAVES_TRAINING_GROUNDS, QuestHelperQuest.SWAN_SONG, QuestHelperQuest.RECIPE_FOR_DISASTER_FINALE, QuestHelperQuest.GRIM_TALES, QuestHelperQuest.DREAM_MENTOR, QuestHelperQuest.WILDERNESS_MEDIUM, QuestHelperQuest.KARAMJA_MEDIUM, QuestHelperQuest.KOUREND_MEDIUM, QuestHelperQuest.LUMBRIDGE_MEDIUM, QuestHelperQuest.MORYTANIA_MEDIUM, QuestHelperQuest.DEVIOUS_MINDS, QuestHelperQuest.THE_FREMENNIK_EXILES, QuestHelperQuest.SINS_OF_THE_FATHER, QuestHelperQuest.BENEATH_CURSED_SANDS, QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestHelperQuest.MONKEY_MADNESS_II, QuestHelperQuest.FREMENNIK_MEDIUM, QuestHelperQuest.A_NIGHT_AT_THE_THEATRE, QuestHelperQuest.DRAGON_SLAYER_II, QuestHelperQuest.SECRETS_OF_THE_NORTH, QuestHelperQuest.SONG_OF_THE_ELVES, QuestHelperQuest.DESERT_TREASURE_II, QuestHelperQuest.THE_CORSAIR_CURSE, QuestHelperQuest.BALLOON_TRANSPORT_CRAFTING_GUILD, QuestHelperQuest.BALLOON_TRANSPORT_GRAND_TREE, QuestHelperQuest.BALLOON_TRANSPORT_VARROCK, QuestHelperQuest.BALLOON_TRANSPORT_CASTLE_WARS, QuestHelperQuest.SECRETS_OF_THE_NORTH, QuestHelperQuest.THE_PATH_OF_GLOUPHRIE, QuestHelperQuest.THE_GARDEN_OF_DEATH, QuestHelperQuest.IN_SEARCH_OF_KNOWLEDGE, QuestHelperQuest.BEAR_YOUR_SOUL, QuestHelperQuest.ENCHANTED_KEY, QuestHelperQuest.FAMILY_PEST, QuestHelperQuest.HOPESPEARS_WILL, QuestHelperQuest.THE_MAGE_ARENA, QuestHelperQuest.THE_MAGE_ARENA_II, QuestHelperQuest.WESTERN_MEDIUM, QuestHelperQuest.DESERT_MEDIUM, QuestHelperQuest.ARDOUGNE_HARD, QuestHelperQuest.ARDOUGNE_ELITE, QuestHelperQuest.DESERT_HARD, QuestHelperQuest.DESERT_ELITE, QuestHelperQuest.FALADOR_HARD, QuestHelperQuest.FALADOR_ELITE, QuestHelperQuest.FREMENNIK_HARD, QuestHelperQuest.FREMENNIK_ELITE, QuestHelperQuest.KANDARIN_HARD, QuestHelperQuest.KANDARIN_ELITE, QuestHelperQuest.KARAMJA_HARD, QuestHelperQuest.KARAMJA_ELITE, QuestHelperQuest.KOUREND_HARD, QuestHelperQuest.KOUREND_ELITE, QuestHelperQuest.LUMBRIDGE_HARD, QuestHelperQuest.LUMBRIDGE_ELITE, QuestHelperQuest.MORYTANIA_HARD, QuestHelperQuest.MORYTANIA_ELITE, QuestHelperQuest.VARROCK_HARD, QuestHelperQuest.VARROCK_ELITE, QuestHelperQuest.WESTERN_HARD, QuestHelperQuest.WESTERN_ELITE, QuestHelperQuest.WILDERNESS_HARD, QuestHelperQuest.WILDERNESS_ELITE});
    private static final List<QuestHelperQuest> releaseOrder = ImmutableList.of((Object)((Object)QuestHelperQuest.COOKS_ASSISTANT), (Object)((Object)QuestHelperQuest.DEMON_SLAYER), (Object)((Object)QuestHelperQuest.THE_RESTLESS_GHOST), (Object)((Object)QuestHelperQuest.ROMEO__JULIET), (Object)((Object)QuestHelperQuest.SHEEP_SHEARER), (Object)((Object)QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG), (Object)((Object)QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG), (Object)((Object)QuestHelperQuest.ERNEST_THE_CHICKEN), (Object)((Object)QuestHelperQuest.VAMPYRE_SLAYER), (Object)((Object)QuestHelperQuest.IMP_CATCHER), (Object)((Object)QuestHelperQuest.PRINCE_ALI_RESCUE), (Object)((Object)QuestHelperQuest.DORICS_QUEST), (Object[])new QuestHelperQuest[]{QuestHelperQuest.BLACK_KNIGHTS_FORTRESS, QuestHelperQuest.WITCHS_POTION, QuestHelperQuest.THE_KNIGHTS_SWORD, QuestHelperQuest.GOBLIN_DIPLOMACY, QuestHelperQuest.PIRATES_TREASURE, QuestHelperQuest.DRAGON_SLAYER_I, QuestHelperQuest.DRUIDIC_RITUAL, QuestHelperQuest.LOST_CITY, QuestHelperQuest.WITCHS_HOUSE, QuestHelperQuest.MERLINS_CRYSTAL, QuestHelperQuest.HEROES_QUEST, QuestHelperQuest.SCORPION_CATCHER, QuestHelperQuest.FAMILY_CREST, QuestHelperQuest.TRIBAL_TOTEM, QuestHelperQuest.FISHING_CONTEST, QuestHelperQuest.MONKS_FRIEND, QuestHelperQuest.TEMPLE_OF_IKOV, QuestHelperQuest.CLOCK_TOWER, QuestHelperQuest.HOLY_GRAIL, QuestHelperQuest.TREE_GNOME_VILLAGE, QuestHelperQuest.FIGHT_ARENA, QuestHelperQuest.HAZEEL_CULT, QuestHelperQuest.SHEEP_HERDER, QuestHelperQuest.PLAGUE_CITY, QuestHelperQuest.SEA_SLUG, QuestHelperQuest.WATERFALL_QUEST, QuestHelperQuest.BIOHAZARD, QuestHelperQuest.JUNGLE_POTION, QuestHelperQuest.THE_GRAND_TREE, QuestHelperQuest.SHILO_VILLAGE, QuestHelperQuest.UNDERGROUND_PASS, QuestHelperQuest.OBSERVATORY_QUEST, QuestHelperQuest.THE_TOURIST_TRAP, QuestHelperQuest.WATCHTOWER, QuestHelperQuest.DWARF_CANNON, QuestHelperQuest.MURDER_MYSTERY, QuestHelperQuest.THE_DIG_SITE, QuestHelperQuest.GERTRUDES_CAT, QuestHelperQuest.LEGENDS_QUEST, QuestHelperQuest.RUNE_MYSTERIES, QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestHelperQuest.ELEMENTAL_WORKSHOP_I, QuestHelperQuest.PRIEST_IN_PERIL, QuestHelperQuest.NATURE_SPIRIT, QuestHelperQuest.DEATH_PLATEAU, QuestHelperQuest.TROLL_STRONGHOLD, QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestHelperQuest.REGICIDE, QuestHelperQuest.EADGARS_RUSE, QuestHelperQuest.SHADES_OF_MORTTON, QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestHelperQuest.HORROR_FROM_THE_DEEP, QuestHelperQuest.THRONE_OF_MISCELLANIA, QuestHelperQuest.MONKEY_MADNESS_I, QuestHelperQuest.HAUNTED_MINE, QuestHelperQuest.TROLL_ROMANCE, QuestHelperQuest.IN_SEARCH_OF_THE_MYREQUE, QuestHelperQuest.CREATURE_OF_FENKENSTRAIN, QuestHelperQuest.ROVING_ELVES, QuestHelperQuest.GHOSTS_AHOY, QuestHelperQuest.ONE_SMALL_FAVOUR, QuestHelperQuest.MOUNTAIN_DAUGHTER, QuestHelperQuest.BETWEEN_A_ROCK, QuestHelperQuest.THE_FEUD, QuestHelperQuest.THE_GOLEM, QuestHelperQuest.DESERT_TREASURE, QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestHelperQuest.TEARS_OF_GUTHIX, QuestHelperQuest.ZOGRE_FLESH_EATERS, QuestHelperQuest.THE_LOST_TRIBE, QuestHelperQuest.THE_GIANT_DWARF, QuestHelperQuest.RECRUITMENT_DRIVE, QuestHelperQuest.MOURNINGS_END_PART_I, QuestHelperQuest.FORGETTABLE_TALE, QuestHelperQuest.GARDEN_OF_TRANQUILLITY, QuestHelperQuest.A_TAIL_OF_TWO_CATS, QuestHelperQuest.WANTED, QuestHelperQuest.MOURNINGS_END_PART_II, QuestHelperQuest.RUM_DEAL, QuestHelperQuest.SHADOW_OF_THE_STORM, QuestHelperQuest.MAKING_HISTORY, QuestHelperQuest.RATCATCHERS, QuestHelperQuest.SPIRITS_OF_THE_ELID, QuestHelperQuest.DEVIOUS_MINDS, QuestHelperQuest.THE_HAND_IN_THE_SAND, QuestHelperQuest.ENAKHRAS_LAMENT, QuestHelperQuest.CABIN_FEVER, QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS, QuestHelperQuest.RECIPE_FOR_DISASTER, QuestHelperQuest.RECIPE_FOR_DISASTER_START, QuestHelperQuest.RECIPE_FOR_DISASTER_DWARF, QuestHelperQuest.RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE, QuestHelperQuest.RECIPE_FOR_DISASTER_PIRATE_PETE, QuestHelperQuest.RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE, QuestHelperQuest.RECIPE_FOR_DISASTER_EVIL_DAVE, QuestHelperQuest.RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR, QuestHelperQuest.RECIPE_FOR_DISASTER_SIR_AMIK_VARZE, QuestHelperQuest.RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE, QuestHelperQuest.RECIPE_FOR_DISASTER_FINALE, QuestHelperQuest.IN_AID_OF_THE_MYREQUE, QuestHelperQuest.A_SOULS_BANE, QuestHelperQuest.RAG_AND_BONE_MAN_I, QuestHelperQuest.RAG_AND_BONE_MAN_II, QuestHelperQuest.SWAN_SONG, QuestHelperQuest.ROYAL_TROUBLE, QuestHelperQuest.DEATH_TO_THE_DORGESHUUN, QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestHelperQuest.LUNAR_DIPLOMACY, QuestHelperQuest.THE_EYES_OF_GLOUPHRIE, QuestHelperQuest.DARKNESS_OF_HALLOWVALE, QuestHelperQuest.THE_SLUG_MENACE, QuestHelperQuest.ELEMENTAL_WORKSHOP_II, QuestHelperQuest.MY_ARMS_BIG_ADVENTURE, QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestHelperQuest.EAGLES_PEAK, QuestHelperQuest.ANIMAL_MAGNETISM, QuestHelperQuest.CONTACT, QuestHelperQuest.COLD_WAR, QuestHelperQuest.THE_FREMENNIK_ISLES, QuestHelperQuest.TOWER_OF_LIFE, QuestHelperQuest.THE_GREAT_BRAIN_ROBBERY, QuestHelperQuest.WHAT_LIES_BELOW, QuestHelperQuest.OLAFS_QUEST, QuestHelperQuest.ANOTHER_SLICE_OF_HAM, QuestHelperQuest.DREAM_MENTOR, QuestHelperQuest.GRIM_TALES, QuestHelperQuest.KINGS_RANSOM, QuestHelperQuest.MONKEY_MADNESS_II, QuestHelperQuest.MISTHALIN_MYSTERY, QuestHelperQuest.CLIENT_OF_KOUREND, QuestHelperQuest.BONE_VOYAGE, QuestHelperQuest.THE_QUEEN_OF_THIEVES, QuestHelperQuest.THE_DEPTHS_OF_DESPAIR, QuestHelperQuest.THE_CORSAIR_CURSE, QuestHelperQuest.DRAGON_SLAYER_II, QuestHelperQuest.TALE_OF_THE_RIGHTEOUS, QuestHelperQuest.A_TASTE_OF_HOPE, QuestHelperQuest.MAKING_FRIENDS_WITH_MY_ARM, QuestHelperQuest.THE_FORSAKEN_TOWER, QuestHelperQuest.THE_ASCENT_OF_ARCEUUS, QuestHelperQuest.X_MARKS_THE_SPOT, QuestHelperQuest.SONG_OF_THE_ELVES, QuestHelperQuest.THE_FREMENNIK_EXILES, QuestHelperQuest.SINS_OF_THE_FATHER, QuestHelperQuest.A_PORCINE_OF_INTEREST, QuestHelperQuest.GETTING_AHEAD, QuestHelperQuest.BELOW_ICE_MOUNTAIN, QuestHelperQuest.A_NIGHT_AT_THE_THEATRE, QuestHelperQuest.A_KINGDOM_DIVIDED, QuestHelperQuest.LAND_OF_THE_GOBLINS, QuestHelperQuest.TEMPLE_OF_THE_EYE, QuestHelperQuest.BENEATH_CURSED_SANDS, QuestHelperQuest.SLEEPING_GIANTS, QuestHelperQuest.THE_GARDEN_OF_DEATH, QuestHelperQuest.THE_PATH_OF_GLOUPHRIE, QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestHelperQuest.THE_MAGE_ARENA, QuestHelperQuest.ENTER_THE_ABYSS, QuestHelperQuest.CURSE_OF_THE_EMPTY_LORD, QuestHelperQuest.SKIPPY_AND_THE_MOGRES, QuestHelperQuest.ENCHANTED_KEY, QuestHelperQuest.LAIR_OF_TARN_RAZORLOR, QuestHelperQuest.THE_GENERALS_SHADOW, QuestHelperQuest.ARCHITECTURAL_ALLIANCE, QuestHelperQuest.BEAR_YOUR_SOUL, QuestHelperQuest.FAMILY_PEST, QuestHelperQuest.THE_MAGE_ARENA_II, QuestHelperQuest.IN_SEARCH_OF_KNOWLEDGE, QuestHelperQuest.DADDYS_HOME, QuestHelperQuest.HOPESPEARS_WILL, QuestHelperQuest.SECRETS_OF_THE_NORTH, QuestHelperQuest.HIS_FAITHFUL_SERVANTS, QuestHelperQuest.DESERT_TREASURE_II});

    public static String normalizeQuestName(String questName) {
        return QUEST_NAME_PATTERN.matcher(questName).replaceAll("").trim();
    }

    public static Comparator<QuestHelper> sortOptimalOrder() {
        return Comparator.comparing(q -> QuestOrders.getOptimalOrder().indexOf((Object)q.getQuest()));
    }

    public static Comparator<QuestHelper> sortOptimalIronmanOrder() {
        return Comparator.comparing(q -> QuestOrders.getOptimalIronmanOrder().indexOf((Object)q.getQuest()));
    }

    public static Comparator<QuestHelper> sortAToZ() {
        return Comparator.comparing(q -> QuestOrders.normalizeQuestName(q.getQuest().getName()));
    }

    public static Comparator<QuestHelper> sortZToA() {
        return Comparator.comparing(q -> QuestOrders.normalizeQuestName(q.getQuest().getName()), Comparator.reverseOrder());
    }

    public static Comparator<QuestHelper> sortByRelease() {
        return Comparator.comparing(q -> QuestOrders.getReleaseOrder().indexOf((Object)q.getQuest()));
    }

    public static Comparator<QuestHelper> sortByQuestPointRewardAscending() {
        return Comparator.comparing(q -> q.getQuestPointReward() != null ? q.getQuestPointReward().getPoints() : 0);
    }

    public static Comparator<QuestHelper> sortByQuestPointRewardDescending() {
        return Comparator.comparing(q -> q.getQuestPointReward() != null ? q.getQuestPointReward().getPoints() : 0, Comparator.reverseOrder());
    }

    public static List<QuestHelperQuest> getOptimalOrder() {
        return optimalOrder;
    }

    public static List<QuestHelperQuest> getOptimalIronmanOrder() {
        return optimalIronmanOrder;
    }

    public static List<QuestHelperQuest> getReleaseOrder() {
        return releaseOrder;
    }
}

