/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.panel.DynamicPaddedGridLayout;
import com.questhelper.panel.PanelDetails;
import com.questhelper.panel.QuestOverviewPanel;
import com.questhelper.panel.QuestRequirementPanel;
import com.questhelper.panel.QuestRequirementWrapperPanel;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.QuestStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.SwingUtil;

public class QuestStepPanel
extends JPanel {
    private static final int TITLE_PADDING = 5;
    PanelDetails panelDetails;
    private final JPanel headerPanel = new JPanel();
    private final JLabel headerLabel = new JLabel();
    private final JPanel bodyPanel = new JPanel();
    private final JCheckBox lockStep = new JCheckBox();
    private final JPanel leftTitleContainer;
    private final JPanel viewControls;
    private QuestStep currentlyHighlighted = null;
    private boolean stepAutoLocked;
    private final HashMap<QuestStep, JLabel> steps = new HashMap();
    private final ArrayList<QuestRequirementPanel> requirementPanels = new ArrayList();

    public QuestStepPanel(PanelDetails panelDetails, QuestStep currentStep, QuestHelper quest, Client client) {
        this.panelDetails = panelDetails;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.leftTitleContainer = new JPanel(new BorderLayout(5, 0));
        this.headerLabel.setText(panelDetails.getHeader());
        this.headerLabel.setFont(FontManager.getRunescapeBoldFont());
        this.headerLabel.setMinimumSize(new Dimension(1, this.headerLabel.getPreferredSize().height));
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
        this.headerPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.headerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.leftTitleContainer.add((Component)this.headerLabel, "Center");
        this.headerPanel.add((Component)this.leftTitleContainer, "West");
        this.viewControls = new JPanel(new GridLayout(1, 3, 10, 0));
        SwingUtil.addModalTooltip((AbstractButton)this.lockStep, (String)"Mark section as incomplete", (String)"Mark section as complete");
        this.lockStep.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lockStep.addActionListener(ev -> this.lockSection(this.lockStep.isSelected()));
        this.lockStep.setVisible(false);
        this.headerPanel.add((Component)this.lockStep, "East");
        this.viewControls.add(this.lockStep);
        this.headerPanel.add((Component)this.viewControls, "East");
        if (panelDetails.contains(currentStep)) {
            this.headerLabel.setForeground(Color.BLACK);
            this.headerPanel.setBackground(ColorScheme.BRAND_ORANGE);
            this.viewControls.setBackground(ColorScheme.BRAND_ORANGE);
            this.leftTitleContainer.setBackground(ColorScheme.BRAND_ORANGE);
        } else {
            this.headerLabel.setForeground(Color.WHITE);
            this.headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            this.viewControls.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            this.leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        }
        this.bodyPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        if (panelDetails.getRequirements() != null && !panelDetails.getRequirements().isEmpty()) {
            this.addRequirements("Bring the following items:", panelDetails.getRequirements(), "North");
        }
        if (panelDetails.getRecommended() != null && !panelDetails.getRecommended().isEmpty()) {
            this.addRequirements("Optionally bring the following:", panelDetails.getRecommended(), "Center");
        }
        JPanel questStepsPanel = new JPanel();
        questStepsPanel.setLayout(new BoxLayout(questStepsPanel, 1));
        questStepsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        for (QuestStep step : panelDetails.getSteps()) {
            JLabel questStepLabel = new JLabel();
            questStepLabel.setLayout(new BorderLayout());
            questStepLabel.setHorizontalAlignment(2);
            questStepLabel.setVerticalAlignment(1);
            questStepLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            questStepLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR.brighter()), BorderFactory.createEmptyBorder(5, 5, 10, 0)));
            questStepLabel.setText(this.generateText(step));
            questStepLabel.setOpaque(true);
            questStepLabel.setVisible(step.isShowInSidebar());
            this.steps.put(step, questStepLabel);
            questStepsPanel.add(questStepLabel);
        }
        this.bodyPanel.add((Component)questStepsPanel, "South");
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        if (!panelDetails.getSteps().contains(currentStep)) {
            this.collapse();
        }
        this.updateHighlightCheck(client, currentStep, quest);
    }

    public void addRequirements(String text, List<Requirement> reqs, String borderLayout) {
        JPanel questRequirementsPanel = new JPanel();
        questRequirementsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        questRequirementsPanel.setLayout(new BorderLayout());
        questRequirementsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel questRequirementsHeader = new JPanel();
        questRequirementsHeader.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        questRequirementsHeader.setLayout(new BorderLayout());
        questRequirementsHeader.setBorder(new EmptyBorder(5, 5, 5, 10));
        JLabel questReqsTitle = new JLabel();
        questReqsTitle.setForeground(Color.WHITE);
        questReqsTitle.setText(text);
        questReqsTitle.setMinimumSize(new Dimension(1, questRequirementsHeader.getPreferredSize().height));
        questRequirementsHeader.add((Component)questReqsTitle, "North");
        JPanel questRequirementsListPanel = new JPanel();
        questRequirementsListPanel.setLayout(new DynamicPaddedGridLayout(0, 1, 0, 1));
        questRequirementsListPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        for (Requirement req : reqs) {
            QuestRequirementPanel reqPanel = new QuestRequirementPanel(req);
            this.requirementPanels.add(reqPanel);
            questRequirementsListPanel.add(new QuestRequirementWrapperPanel(reqPanel));
        }
        questRequirementsPanel.add((Component)questRequirementsHeader, "North");
        questRequirementsPanel.add((Component)questRequirementsListPanel, "Center");
        this.bodyPanel.add((Component)questRequirementsPanel, borderLayout);
    }

    public String generateText(QuestStep step) {
        StringBuilder text = new StringBuilder();
        step.getText().forEach(line -> text.append((String)line).append("<br><br>"));
        text.replace(text.length() - 8, text.length(), "");
        return "<html><body style='text-align:left'>" + text + "</body></html>";
    }

    public List<QuestStep> getSteps() {
        return new ArrayList<QuestStep>(this.steps.keySet());
    }

    public HashMap<QuestStep, JLabel> getStepsLabels() {
        return this.steps;
    }

    public void setLockable(boolean canLock) {
        this.lockStep.setVisible(canLock);
    }

    public void updateHighlightCheck(Client client, QuestStep newStep, QuestHelper currentQuest) {
        if (this.panelDetails.getHideCondition() == null || !this.panelDetails.getHideCondition().check(client)) {
            this.setVisible(true);
            boolean highlighted = false;
            this.setLockable(this.panelDetails.getLockingQuestSteps() != null && (this.panelDetails.getVars() == null || this.panelDetails.getVars().contains(currentQuest.getVar())));
            for (QuestStep step : this.getSteps()) {
                if (step != newStep && !step.getSubsteps().contains(newStep)) continue;
                highlighted = true;
                this.updateHighlight(step);
                break;
            }
            if (!highlighted) {
                this.removeHighlight();
            }
        } else {
            this.setVisible(false);
        }
    }

    public void updateHighlight(QuestStep currentStep) {
        this.expand();
        if (this.currentlyHighlighted != null && this.steps.get(this.currentlyHighlighted) != null) {
            this.steps.get(this.currentlyHighlighted).setForeground(Color.LIGHT_GRAY);
        } else {
            this.headerLabel.setForeground(Color.BLACK);
            this.headerPanel.setBackground(ColorScheme.BRAND_ORANGE);
            this.viewControls.setBackground(ColorScheme.BRAND_ORANGE);
            this.leftTitleContainer.setBackground(ColorScheme.BRAND_ORANGE);
        }
        if (this.steps.get(currentStep) != null) {
            this.steps.get(currentStep).setForeground(ColorScheme.BRAND_ORANGE);
        }
        this.currentlyHighlighted = currentStep;
    }

    public void removeHighlight() {
        if (this.currentlyHighlighted != null) {
            this.headerLabel.setForeground(Color.WHITE);
            if (this.isCollapsed()) {
                this.applyDimmer(false, this.headerPanel);
            }
            this.headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            this.viewControls.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            this.leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            if (this.steps.get(this.currentlyHighlighted) != null) {
                this.steps.get(this.currentlyHighlighted).setForeground(Color.LIGHT_GRAY);
            }
            this.currentlyHighlighted = null;
        }
        this.collapse();
    }

    public void updateLock() {
        if (this.panelDetails.getLockingQuestSteps() == null) {
            return;
        }
        if (this.panelDetails.getLockingQuestSteps().isUnlockable()) {
            this.stepAutoLocked = false;
            this.lockStep.setEnabled(true);
        } else {
            if (!this.stepAutoLocked) {
                this.collapse();
            }
            this.stepAutoLocked = true;
            this.lockStep.setEnabled(false);
        }
        if (this.panelDetails.getLockingQuestSteps().isLocked()) {
            this.lockStep.setSelected(true);
        }
    }

    private void lockSection(boolean locked) {
        if (locked) {
            this.panelDetails.getLockingQuestSteps().setLockedManually(true);
            if (!this.isCollapsed()) {
                this.collapse();
            }
        } else {
            this.panelDetails.getLockingQuestSteps().setLockedManually(false);
            if (this.isCollapsed()) {
                this.expand();
            }
        }
    }

    void collapse() {
        if (!this.isCollapsed()) {
            this.bodyPanel.setVisible(false);
            this.applyDimmer(false, this.headerPanel);
        }
    }

    void expand() {
        if (this.isCollapsed()) {
            this.bodyPanel.setVisible(true);
            this.applyDimmer(true, this.headerPanel);
        }
    }

    boolean isCollapsed() {
        return !this.bodyPanel.isVisible();
    }

    private void applyDimmer(boolean brighten, JPanel panel) {
        for (Component component : panel.getComponents()) {
            Color color = component.getForeground();
            component.setForeground(brighten ? color.brighter() : color.darker());
        }
    }

    public void updateRequirements(Client client, List<Item> bankItems, QuestOverviewPanel questOverviewPanel) {
        questOverviewPanel.updateRequirementPanels(client, this.requirementPanels, bankItems);
        this.updateStepVisibility(client);
    }

    public void updateStepVisibility(Client client) {
        for (QuestStep step : this.steps.keySet()) {
            step.setShowInSidebar(step.getConditionToHide() == null || !step.getConditionToHide().check(client));
            this.steps.get(step).setVisible(step.isShowInSidebar());
        }
    }
}

