/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.managers.QuestManager;
import com.questhelper.panel.QuestHelperPanel;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.tools.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.QuestState;
import net.runelite.client.ui.ColorScheme;

public class QuestSelectPanel
extends JPanel {
    private final List<String> keywords = new ArrayList<String>();
    private final QuestHelper questHelper;
    private final QuestManager questManager;
    private static final ImageIcon START_ICON = Icon.START.getIcon();

    public QuestSelectPanel(QuestHelperPlugin questHelperPlugin, QuestManager questManager, QuestHelperPanel questHelperPanel, QuestHelper questHelper, QuestState questState) {
        this.questHelper = questHelper;
        this.questManager = questManager;
        this.keywords.addAll(questHelper.getQuest().getKeywords());
        this.setLayout(new BorderLayout(3, 0));
        this.setPreferredSize(new Dimension(225, 20));
        JLabel nameLabel = new JLabel(questHelper.getQuest().getName());
        Color color = questState == QuestState.FINISHED ? questHelperPlugin.getConfig().passColour() : (questState == QuestState.IN_PROGRESS ? new Color(240, 207, 123) : Color.WHITE);
        nameLabel.setForeground(color);
        this.add((Component)nameLabel, "Center");
        if (questState != QuestState.FINISHED) {
            JButton startButton = new JButton();
            startButton.setIcon(START_ICON);
            startButton.addActionListener(e -> {
                questManager.setSidebarSelectedQuest(questHelper);
                questHelperPanel.emptyBar();
            });
            this.add((Component)startButton, "After");
        }
    }

    public QuestSelectPanel(String text) {
        this.questHelper = null;
        this.questManager = null;
        this.setLayout(new BorderLayout(3, 3));
        this.setPreferredSize(new Dimension(225, 30));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel nameLabel = new JLabel(text);
        Color color = Color.WHITE;
        nameLabel.setForeground(color);
        this.add((Component)nameLabel, "Center");
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public QuestHelper getQuestHelper() {
        return this.questHelper;
    }
}

