/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.rewards.Reward;
import com.questhelper.tools.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class QuestRewardPanel
extends JPanel {
    private static final ImageIcon INFO_ICON = Icon.INFO_ICON.getIcon();
    private JLabel label;
    private final Reward reward;

    public QuestRewardPanel(Reward reward) {
        this.reward = reward;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        String html1 = "<html><body style='padding: 0px; margin: 0px; width: 140px'>";
        String html2 = "</body></html>";
        this.label = new JLabel(html1 + reward.getDisplayText() + html2);
        this.label.setForeground(Color.WHITE);
        this.label.setSize(this.label.getPreferredSize());
        this.setPreferredSize(this.label.getSize());
        this.add((Component)this.label, "West");
    }

    private void addButtonToPanel(String tooltipText) {
        String html1 = "<html><body>";
        String html2 = "</body></html>";
        tooltipText = tooltipText.replaceAll("\\n", "<br>");
        JButton b = new JButton(INFO_ICON);
        b.setPreferredSize(new Dimension(10, 10));
        b.setToolTipText(html1 + tooltipText + html2);
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        this.add(b);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public Reward getReward() {
        return this.reward;
    }
}

