/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.tools.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class QuestRequirementPanel
extends JPanel {
    private static final ImageIcon INFO_ICON = Icon.INFO_ICON.getIcon();
    private JLabel label;
    private final Requirement requirement;

    public QuestRequirementPanel(final Requirement requirement) {
        ItemRequirement itemRequirement;
        this.requirement = requirement;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        StringBuilder text = new StringBuilder();
        if (requirement instanceof ItemRequirement && (itemRequirement = (ItemRequirement)requirement).showQuantity()) {
            text.append(itemRequirement.getQuantity()).append(" x ");
        }
        text.append(requirement.getDisplayText());
        String html1 = "<html><body style='padding: 0px; margin: 0px; width: 140px'>";
        String html2 = "</body></html>";
        this.label = new JLabel(html1 + text + html2);
        this.label.setForeground(Color.GRAY);
        this.label.setSize(this.label.getPreferredSize());
        this.setPreferredSize(this.label.getSize());
        this.add((Component)this.label, "West");
        if (requirement instanceof ItemRequirement) {
            final JPopupMenu menu = new JPopupMenu("Menu");
            final int id = ((ItemRequirement)requirement).getId();
            JMenuItem wikiLink = new JMenuItem(new AbstractAction("Go to wiki.."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (requirement.getUrlSuffix() == null) {
                            Desktop.getDesktop().browse(new URI("https://oldschool.runescape.wiki/w/Special:Lookup?type=item&id=" + id));
                        } else {
                            Desktop.getDesktop().browse(new URI("https://oldschool.runescape.wiki/w/" + requirement.getUrlSuffix()));
                        }
                    }
                    catch (IOException | URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            menu.add(wikiLink);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ItemRequirement iReq = (ItemRequirement)requirement;
                    if ((iReq.getId() != -1 || iReq.getId() != -1 && iReq.getUrlSuffix() != null || iReq.getId() == -1 && iReq.getUrlSuffix() != null) && SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                        menu.show(QuestRequirementPanel.this.label, e.getX(), e.getY());
                    }
                }
            });
        }
        if (requirement.getTooltip() != null) {
            this.addButtonToPanel(requirement.getTooltip());
        }
    }

    private void addButtonToPanel(String tooltipText) {
        String html1 = "<html><body>";
        String html2 = "</body></html>";
        tooltipText = tooltipText.replaceAll("\\n", "<br>");
        JButton b = new JButton(INFO_ICON);
        b.setPreferredSize(new Dimension(10, 10));
        b.setToolTipText(html1 + tooltipText + html2);
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        this.add(b);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }
}

