/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.managers.QuestManager;
import com.questhelper.panel.DropdownRenderer;
import com.questhelper.panel.DynamicPaddedGridLayout;
import com.questhelper.panel.PanelDetails;
import com.questhelper.panel.QuestRequirementPanel;
import com.questhelper.panel.QuestRequirementWrapperPanel;
import com.questhelper.panel.QuestRewardPanel;
import com.questhelper.panel.QuestRewardWrapperPanel;
import com.questhelper.panel.QuestStepPanel;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.ExternalQuestResources;
import com.questhelper.questinfo.HelperConfig;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.NoItemRequirement;
import com.questhelper.rewards.Reward;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;

public class QuestOverviewPanel
extends JPanel {
    private final QuestHelperPlugin questHelperPlugin;
    private final QuestManager questManager;
    public QuestHelper currentQuest;
    private final JPanel questStepsContainer = new JPanel();
    private final JPanel actionsContainer = new JPanel();
    private final JPanel configContainer = new JPanel();
    private final JPanel introPanel = new JPanel();
    private final JLabel questOverviewNotes = new JLabel();
    private final JPanel questGeneralRequirementsListPanel = new JPanel();
    private final JPanel questGeneralRecommendedListPanel = new JPanel();
    private final JPanel questItemRequirementsListPanel = new JPanel();
    private final JPanel questItemRecommendedListPanel = new JPanel();
    private final JPanel questCombatRequirementsListPanel = new JPanel();
    private final JPanel questOverviewNotesPanel = new JPanel();
    private final JPanel questRewardPanel = new JPanel();
    private final JPanel externalQuestResourcesPanel = new JPanel();
    private final JPanel questGeneralRequirementsHeader = new JPanel();
    private final JPanel questGeneralRecommendedHeader = new JPanel();
    private final JPanel questItemRequirementsHeader = new JPanel();
    private final JPanel questCombatRequirementHeader = new JPanel();
    private final JPanel questItemRecommendedHeader = new JPanel();
    private final JPanel questNoteHeader = new JPanel();
    private final JPanel questRewardHeader = new JPanel();
    private final JPanel externalQuestResourcesHeader = new JPanel();
    private final JLabel questNameLabel = new JLabel();
    private static final ImageIcon CLOSE_ICON = Icon.CLOSE.getIcon();
    private static final ImageIcon INFO_ICON = Icon.INFO_ICON.getIcon();
    private final JButton collapseBtn = new JButton();
    private final List<QuestStepPanel> questStepPanelList = new ArrayList<QuestStepPanel>();
    private final List<QuestRequirementPanel> requirementPanels = new ArrayList<QuestRequirementPanel>();

    public QuestOverviewPanel(QuestHelperPlugin questHelperPlugin, QuestManager questManager) {
        this.questManager = questManager;
        this.questHelperPlugin = questHelperPlugin;
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.actionsContainer.setLayout(new BorderLayout());
        this.actionsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.actionsContainer.setPreferredSize(new Dimension(0, 30));
        this.actionsContainer.setBorder(new EmptyBorder(5, 5, 5, 10));
        this.actionsContainer.setVisible(false);
        JPanel viewControls = new JPanel(new GridLayout(1, 3, 10, 0));
        viewControls.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JButton closeBtn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)closeBtn);
        closeBtn.setIcon(CLOSE_ICON);
        closeBtn.setToolTipText("Close helper");
        closeBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        closeBtn.setUI(new BasicButtonUI());
        closeBtn.addActionListener(ev -> this.closeHelper());
        viewControls.add(closeBtn);
        this.actionsContainer.add((Component)viewControls, "East");
        this.questNameLabel.setForeground(Color.WHITE);
        this.questNameLabel.setText("");
        JPanel leftTitleContainer = new JPanel(new BorderLayout(5, 0));
        leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftTitleContainer.add((Component)this.questNameLabel, "Center");
        this.actionsContainer.add((Component)leftTitleContainer, "West");
        this.configContainer.setLayout(new BorderLayout());
        this.configContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.configContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        BoxLayout boxLayoutOverview2 = new BoxLayout(this.configContainer, 1);
        this.configContainer.setLayout(boxLayoutOverview2);
        this.configContainer.setVisible(false);
        JPanel configHeaderPanel = new JPanel();
        configHeaderPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        configHeaderPanel.setLayout(new BorderLayout());
        configHeaderPanel.setBorder(new EmptyBorder(5, 5, 5, 10));
        JLabel configHeaderText = new JLabel();
        configHeaderText.setForeground(Color.WHITE);
        configHeaderText.setText("Configuration:");
        configHeaderText.setMinimumSize(new Dimension(1, configHeaderPanel.getPreferredSize().height));
        configHeaderPanel.add(configHeaderText);
        this.configContainer.add(configHeaderPanel);
        this.introPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.introPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.introPanel.setLayout(new BorderLayout());
        this.introPanel.setVisible(false);
        JPanel overviewPanel = new JPanel();
        BoxLayout boxLayoutOverview = new BoxLayout(overviewPanel, 1);
        overviewPanel.setLayout(boxLayoutOverview);
        overviewPanel.add(this.generateRequirementPanel(this.questGeneralRequirementsListPanel, this.questGeneralRequirementsHeader, "General requirements:"));
        overviewPanel.add(this.generateRequirementPanel(this.questGeneralRecommendedListPanel, this.questGeneralRecommendedHeader, "Recommended:"));
        overviewPanel.add(this.generateRequirementPanel(this.questItemRequirementsListPanel, this.questItemRequirementsHeader, "Item requirements:"));
        overviewPanel.add(this.generateRequirementPanel(this.questItemRecommendedListPanel, this.questItemRecommendedHeader, "Recommended items:"));
        overviewPanel.add(this.generateRequirementPanel(this.questCombatRequirementsListPanel, this.questCombatRequirementHeader, "Enemies to defeat:"));
        overviewPanel.add(this.generateRequirementPanel(this.questOverviewNotesPanel, this.questNoteHeader, "Notes:"));
        overviewPanel.add(this.generateRequirementPanel(this.questRewardPanel, this.questRewardHeader, "Rewards:"));
        overviewPanel.add(this.generateRequirementPanel(this.externalQuestResourcesPanel, this.externalQuestResourcesHeader, "External Resources:"));
        this.introPanel.add((Component)overviewPanel, "North");
        this.questStepsContainer.setLayout(new BoxLayout(this.questStepsContainer, 1));
        this.add(this.actionsContainer);
        this.add(this.configContainer);
        this.add(this.introPanel);
        this.add(this.questStepsContainer);
    }

    private JComboBox<Enum> makeNewDropdown(Enum[] values, String key) {
        JComboBox<Enum> dropdown = new JComboBox<Enum>(values);
        dropdown.setFocusable(false);
        dropdown.setForeground(Color.WHITE);
        dropdown.setRenderer(new DropdownRenderer());
        dropdown.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Enum source = (Enum)e.getItem();
                this.questHelperPlugin.getConfigManager().setRSProfileConfiguration("questhelpervars", key, (Object)source);
            }
        });
        String currentVal = this.questHelperPlugin.getConfigManager().getRSProfileConfiguration("questhelpervars", key);
        for (Enum value : values) {
            if (!value.name().equals(currentVal)) continue;
            dropdown.setSelectedItem(value);
        }
        return dropdown;
    }

    private JPanel makeDropdownPanel(JComboBox dropdown, String name) {
        JLabel filterName = new JLabel(name);
        filterName.setForeground(Color.WHITE);
        JPanel filtersPanel = new JPanel();
        filtersPanel.setLayout(new BorderLayout());
        filtersPanel.setMinimumSize(new Dimension(225, 0));
        filtersPanel.add((Component)filterName, "Center");
        filtersPanel.add((Component)dropdown, "East");
        return filtersPanel;
    }

    private JPanel generateRequirementPanel(JPanel listPanel, JPanel headerPanel, String header) {
        JPanel requirementPanel = new JPanel();
        requirementPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        requirementPanel.setLayout(new BorderLayout());
        requirementPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setBorder(new EmptyBorder(5, 5, 5, 10));
        JLabel questItemReqs = new JLabel();
        questItemReqs.setForeground(Color.WHITE);
        questItemReqs.setText(header);
        questItemReqs.setMinimumSize(new Dimension(1, headerPanel.getPreferredSize().height));
        headerPanel.add((Component)questItemReqs, "North");
        listPanel.setLayout(new DynamicPaddedGridLayout(0, 1, 0, 1));
        listPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        requirementPanel.add((Component)headerPanel, "North");
        requirementPanel.add((Component)listPanel, "Center");
        return requirementPanel;
    }

    public void addQuest(QuestHelper quest, boolean isActive) {
        this.currentQuest = quest;
        List<PanelDetails> steps = quest.getPanels();
        QuestStep currentStep = isActive ? quest.getCurrentStep().getSidePanelStep() : new DetailedQuestStep(quest, "Fake step", new Requirement[0]);
        if (quest.getCurrentStep() != null) {
            this.questNameLabel.setText(quest.getQuest().getName());
            this.actionsContainer.setVisible(true);
            if (quest.getConfigs() != null) {
                this.configContainer.setVisible(true);
            }
            this.setupQuestRequirements(quest);
            this.introPanel.setVisible(true);
            for (PanelDetails panelDetail : steps) {
                if (panelDetail.getHideCondition() != null && panelDetail.getHideCondition().check(this.questHelperPlugin.getClient())) continue;
                final QuestStepPanel newStep = new QuestStepPanel(panelDetail, currentStep, quest, this.questHelperPlugin.getClient());
                if (panelDetail.getLockingQuestSteps() != null && (panelDetail.getVars() == null || panelDetail.getVars().contains(this.currentQuest.getVar()))) {
                    newStep.setLockable(true);
                }
                this.questStepPanelList.add(newStep);
                this.questStepsContainer.add(newStep);
                newStep.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 1) {
                            if (newStep.isCollapsed()) {
                                newStep.expand();
                            } else {
                                newStep.collapse();
                            }
                            QuestOverviewPanel.this.updateCollapseText();
                        }
                    }
                });
                this.repaint();
                this.revalidate();
            }
        }
    }

    public void updateSteps() {
        if (this.questStepPanelList == null) {
            return;
        }
        this.questStepPanelList.forEach(panel -> {
            for (QuestStep step : panel.getSteps()) {
                JLabel label = panel.getStepsLabels().get(step);
                if (label == null) continue;
                label.setText(panel.generateText(step));
            }
        });
    }

    public void updateHighlight(Client client, QuestStep newStep) {
        this.questStepPanelList.forEach(panel -> panel.updateHighlightCheck(client, newStep, this.currentQuest));
        this.repaint();
        this.revalidate();
    }

    public void updateLocks() {
        this.questStepPanelList.forEach(QuestStepPanel::updateLock);
        this.repaint();
        this.revalidate();
    }

    public void removeQuest() {
        this.actionsContainer.setVisible(false);
        this.introPanel.setVisible(false);
        this.configContainer.setVisible(false);
        this.configContainer.removeAll();
        this.questStepsContainer.removeAll();
        this.questGeneralRequirementsListPanel.removeAll();
        this.questGeneralRecommendedListPanel.removeAll();
        this.questItemRequirementsListPanel.removeAll();
        this.questItemRecommendedListPanel.removeAll();
        this.questCombatRequirementsListPanel.removeAll();
        this.currentQuest = null;
        this.questOverviewNotesPanel.removeAll();
        this.questRewardPanel.removeAll();
        this.repaint();
        this.revalidate();
    }

    private void closeHelper() {
        this.questManager.shutDownQuestFromSidebar();
    }

    void updateCollapseText() {
        this.collapseBtn.setSelected(this.isAllCollapsed());
    }

    private boolean isAllCollapsed() {
        return this.questStepPanelList.stream().filter(QuestStepPanel::isCollapsed).count() == (long)this.questStepPanelList.size();
    }

    public void setupQuestRequirements(QuestHelper quest) {
        if (quest.getConfigs() != null) {
            JPanel configHeaderPanel = new JPanel();
            configHeaderPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            configHeaderPanel.setLayout(new BorderLayout());
            configHeaderPanel.setBorder(new EmptyBorder(5, 5, 5, 10));
            JLabel configHeaderText = new JLabel();
            configHeaderText.setForeground(Color.WHITE);
            configHeaderText.setText("Configuration:");
            configHeaderText.setMinimumSize(new Dimension(1, configHeaderPanel.getPreferredSize().height));
            configHeaderPanel.add(configHeaderText);
            this.configContainer.add(configHeaderPanel);
            List<HelperConfig> configs = quest.getConfigs();
            for (HelperConfig config : configs) {
                JComboBox<Enum> dropdown = this.makeNewDropdown(config.getEnums(), config.getKey());
                JPanel dropdownPanel = this.makeDropdownPanel(dropdown, config.getName());
                dropdownPanel.setPreferredSize(new Dimension(225, 20));
                this.configContainer.add(dropdownPanel);
            }
        }
        this.updateRequirementsPanels(this.questGeneralRequirementsHeader, this.questGeneralRequirementsListPanel, this.requirementPanels, quest.getGeneralRequirements());
        this.updateRequirementsPanels(this.questGeneralRecommendedHeader, this.questGeneralRecommendedListPanel, this.requirementPanels, quest.getGeneralRecommended());
        this.updateItemRequirementsPanels(this.questItemRequirementsListPanel, this.requirementPanels, quest.getItemRequirements());
        this.updateItemRequirementsPanels(this.questItemRecommendedListPanel, this.requirementPanels, quest.getItemRecommended());
        this.updateCombatRequirementsPanels(quest.getCombatRequirements());
        this.updateExternalResourcesPanel(quest);
        this.updateQuestOverview(quest.getNotes());
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        if (quest.getQuestPointReward() != null) {
            rewards.add(quest.getQuestPointReward());
        }
        if (quest.getExperienceRewards() != null) {
            rewards.addAll(quest.getExperienceRewards());
        }
        if (quest.getItemRewards() != null) {
            rewards.addAll(quest.getItemRewards());
        }
        if (quest.getUnlockRewards() != null) {
            rewards.addAll(quest.getUnlockRewards());
        }
        this.updateRewardsPanels(rewards);
    }

    private void updateRequirementsPanels(JPanel header, JPanel listPanel, List<QuestRequirementPanel> panels, List<Requirement> requirements) {
        if (requirements != null) {
            for (Requirement generalRecommend : requirements) {
                QuestRequirementPanel reqPanel = new QuestRequirementPanel(generalRecommend);
                panels.add(reqPanel);
                listPanel.add(new QuestRequirementWrapperPanel(reqPanel));
                listPanel.setVisible(true);
                header.setVisible(true);
            }
        } else {
            listPanel.setVisible(false);
            header.setVisible(false);
        }
    }

    private void updateItemRequirementsPanels(JPanel listPanel, List<QuestRequirementPanel> panels, List<ItemRequirement> requirements) {
        if (requirements != null) {
            for (Requirement requirement : requirements) {
                QuestRequirementPanel reqPanel = new QuestRequirementPanel(requirement);
                panels.add(reqPanel);
                listPanel.add(new QuestRequirementWrapperPanel(reqPanel));
                listPanel.setVisible(true);
            }
        } else {
            JLabel itemRequiredLabel = new JLabel();
            itemRequiredLabel.setForeground(Color.GRAY);
            itemRequiredLabel.setText("None");
            listPanel.add(itemRequiredLabel);
        }
    }

    private void updateRewardsPanels(List<Reward> rewards) {
        Reward lastReward = null;
        if (!rewards.isEmpty()) {
            for (Reward reward : rewards) {
                if (lastReward != null && lastReward.rewardType() != reward.rewardType()) {
                    this.questRewardPanel.add(new JLabel(" "));
                }
                lastReward = reward;
                QuestRewardPanel rewardPanel = new QuestRewardPanel(reward);
                this.questRewardPanel.add(new QuestRewardWrapperPanel(rewardPanel));
                this.questRewardPanel.setVisible(true);
            }
        } else {
            JLabel itemRequiredLabel = new JLabel();
            itemRequiredLabel.setForeground(Color.GRAY);
            itemRequiredLabel.setText("None");
            this.questRewardPanel.add(itemRequiredLabel);
        }
    }

    private void updateCombatRequirementsPanels(List<String> combatRequirementList) {
        JLabel combatLabel = new JLabel();
        combatLabel.setForeground(Color.GRAY);
        StringBuilder textCombat = new StringBuilder();
        if (combatRequirementList == null) {
            textCombat.append("None");
        } else {
            for (String combatRequirement : combatRequirementList) {
                textCombat.append(combatRequirement);
                textCombat.append("<br>");
            }
        }
        combatLabel.setText("<html><body style = 'text-align:left'>" + textCombat + "</body></html>");
        this.questCombatRequirementsListPanel.add(combatLabel);
    }

    private void updateExternalResourcesPanel(final QuestHelper quest) {
        List<ExternalQuestResources> externalResourcesList;
        try {
            externalResourcesList = Collections.singletonList(ExternalQuestResources.valueOf(quest.getQuest().name().toUpperCase()));
        }
        catch (Exception e) {
            return;
        }
        JLabel externalResources = new JLabel();
        externalResources.setForeground(Color.GRAY);
        final JButton wikiBtn = new JButton();
        wikiBtn.setUI(new BasicButtonUI());
        SwingUtil.removeButtonDecorations((AbstractButton)wikiBtn);
        wikiBtn.setHorizontalAlignment(2);
        wikiBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wikiBtn.setToolTipText("Open the official wiki in your browser.");
        wikiBtn.setText("<html><body>" + quest.getQuest().getName() + " Wiki </body></html>");
        wikiBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                wikiBtn.setForeground(Color.blue.brighter().brighter().brighter());
                wikiBtn.setText("<html><body style = 'text-decoration:underline'>" + quest.getQuest().getName() + " Wiki </body></html>");
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                wikiBtn.setForeground(Color.white);
                wikiBtn.setText("<html><body>" + quest.getQuest().getName() + " Wiki </body></html>");
            }
        });
        for (ExternalQuestResources externalResource : externalResourcesList) {
            if (externalResource.getWikiURL().length() <= 0) continue;
            wikiBtn.addActionListener(ev -> LinkBrowser.browse((String)externalResource.getWikiURL()));
        }
        this.externalQuestResourcesPanel.removeAll();
        this.externalQuestResourcesPanel.add(externalResources);
        this.externalQuestResourcesPanel.add((Component)wikiBtn, "East");
    }

    private void updateQuestOverview(List<String> notes) {
        JLabel overviewLabel = new JLabel();
        overviewLabel.setForeground(Color.GRAY);
        StringBuilder textNote = new StringBuilder();
        if (notes != null) {
            for (String note : notes) {
                textNote.append(note);
                textNote.append("<br><br>");
            }
            overviewLabel.setText("<html><body style = 'text-align:left'>" + textNote + "</body></html>");
            this.questOverviewNotesPanel.add(overviewLabel);
            this.questOverviewNotesPanel.setVisible(true);
            this.questNoteHeader.setVisible(true);
            this.questOverviewNotes.setVisible(true);
        } else {
            this.questOverviewNotes.setVisible(false);
            this.questNoteHeader.setVisible(false);
            this.questOverviewNotesPanel.setVisible(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(225, super.getPreferredSize().height);
    }

    public void updateRequirements(Client client, List<Item> bankItems) {
        this.updateRequirementPanels(client, this.requirementPanels, bankItems);
        if (this.questStepPanelList != null) {
            this.questStepPanelList.forEach(questStepPanel -> questStepPanel.updateRequirements(client, bankItems, this));
        }
        this.revalidate();
    }

    public void updateRequirementPanels(Client client, List<QuestRequirementPanel> reqPanels, List<Item> bankItems) {
        if (reqPanels == null) {
            return;
        }
        for (QuestRequirementPanel requirementPanel : reqPanels) {
            Color newColor;
            if (requirementPanel.getRequirement() instanceof ItemRequirement) {
                ItemRequirement itemRequirement = (ItemRequirement)requirementPanel.getRequirement();
                requirementPanel.getLabel().setText(itemRequirement.getSidebarText());
                requirementPanel.setVisible(itemRequirement.getConditionToHide() == null || !itemRequirement.getConditionToHide().check(client));
                newColor = itemRequirement instanceof NoItemRequirement ? itemRequirement.getColor(client, this.questHelperPlugin.getConfig()) : itemRequirement.getColorConsideringBank(client, false, bankItems, this.questHelperPlugin.getConfig());
            } else {
                newColor = requirementPanel.getRequirement().getColor(client, this.questHelperPlugin.getConfig());
            }
            if (newColor == Color.WHITE) {
                requirementPanel.getLabel().setToolTipText("In bank");
            } else if (newColor == Color.ORANGE) {
                requirementPanel.getLabel().setToolTipText("On steel key ring");
            } else {
                requirementPanel.getLabel().setToolTipText("");
            }
            requirementPanel.getLabel().setForeground(newColor);
        }
    }
}

