/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.managers.QuestManager;
import com.questhelper.panel.DropdownRenderer;
import com.questhelper.panel.DynamicPaddedGridLayout;
import com.questhelper.panel.FixedWidthPanel;
import com.questhelper.panel.QuestOverviewPanel;
import com.questhelper.panel.QuestSelectPanel;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.QuestState;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestHelperPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(QuestHelperPanel.class);
    private final QuestOverviewPanel questOverviewPanel;
    private final FixedWidthPanel questOverviewWrapper = new FixedWidthPanel();
    private JPanel allQuestsCompletedPanel = new JPanel();
    private JPanel searchQuestsPanel;
    private final JPanel allDropdownSections = new JPanel();
    private final JComboBox<Enum> filterDropdown;
    private final JComboBox<Enum> difficultyDropdown;
    private final JComboBox<Enum> orderDropdown;
    private final IconTextField searchBar = new IconTextField();
    private final FixedWidthPanel questListPanel = new FixedWidthPanel();
    private final FixedWidthPanel questListWrapper = new FixedWidthPanel();
    private final JScrollPane scrollableContainer;
    public static final int DROPDOWN_HEIGHT = 20;
    public boolean questActive = false;
    private final ArrayList<QuestSelectPanel> questSelectPanels = new ArrayList();
    QuestHelperPlugin questHelperPlugin;
    QuestManager questManager;
    private static final ImageIcon DISCORD_ICON = Icon.DISCORD.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
    private static final ImageIcon GITHUB_ICON = Icon.GITHUB.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
    private static final ImageIcon PATREON_ICON = Icon.PATREON.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
    private static final ImageIcon SETTINGS_ICON = Icon.SETTINGS.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));

    public QuestHelperPanel(QuestHelperPlugin questHelperPlugin, QuestManager questManager) {
        super(false);
        this.questHelperPlugin = questHelperPlugin;
        this.questManager = questManager;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Quest Helper");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        JPanel viewControls = new JPanel(new GridLayout(1, 3, 10, 0));
        viewControls.setBackground(ColorScheme.DARK_GRAY_COLOR);
        final JButton discordBtn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)discordBtn);
        discordBtn.setIcon(DISCORD_ICON);
        discordBtn.setToolTipText("Get help with the Quest Helper or make suggestions on Discord");
        discordBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        discordBtn.setUI(new BasicButtonUI());
        discordBtn.addActionListener(ev -> LinkBrowser.browse((String)"https://discord.gg/XCfwNnz6RB"));
        discordBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                discordBtn.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                discordBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        viewControls.add(discordBtn);
        final JButton githubBtn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)githubBtn);
        githubBtn.setIcon(GITHUB_ICON);
        githubBtn.setToolTipText("Report issues or contribute on GitHub");
        githubBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        githubBtn.setUI(new BasicButtonUI());
        githubBtn.addActionListener(ev -> LinkBrowser.browse((String)"https://github.com/Zoinkwiz/quest-helper"));
        githubBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                githubBtn.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                githubBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        viewControls.add(githubBtn);
        final JButton patreonBtn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)patreonBtn);
        patreonBtn.setIcon(PATREON_ICON);
        patreonBtn.setToolTipText("Support development on Patreon");
        patreonBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        patreonBtn.setUI(new BasicButtonUI());
        patreonBtn.addActionListener(ev -> LinkBrowser.browse((String)"https://www.patreon.com/zoinkwiz"));
        patreonBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                patreonBtn.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                patreonBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        viewControls.add(patreonBtn);
        titlePanel.add((Component)viewControls, "East");
        JLabel questsCompletedLabel = new JLabel();
        questsCompletedLabel.setForeground(Color.GRAY);
        questsCompletedLabel.setText("<html><body style='text-align:left'>Please log in to see available quests.</body></html>");
        this.allQuestsCompletedPanel.setLayout(new BorderLayout());
        this.allQuestsCompletedPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.allQuestsCompletedPanel.add(questsCompletedLabel);
        this.allQuestsCompletedPanel.setVisible(false);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                QuestHelperPanel.this.onSearchBarChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QuestHelperPanel.this.onSearchBarChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QuestHelperPanel.this.onSearchBarChanged();
            }
        });
        this.searchQuestsPanel = new JPanel();
        this.searchQuestsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.searchQuestsPanel.setLayout(new BorderLayout(0, 6));
        this.searchQuestsPanel.add((Component)this.searchBar, "Center");
        this.searchQuestsPanel.add((Component)this.allQuestsCompletedPanel, "South");
        this.questListPanel.setBorder(new EmptyBorder(8, 10, 0, 10));
        this.questListPanel.setLayout(new DynamicPaddedGridLayout(0, 1, 0, 5));
        this.questListPanel.setAlignmentX(0.0f);
        this.showMatchingQuests("");
        this.filterDropdown = this.makeNewDropdown(QuestHelperConfig.QuestFilter.displayFilters(), "filterListBy");
        JPanel filtersPanel = this.makeDropdownPanel(this.filterDropdown, "Filters");
        filtersPanel.setPreferredSize(new Dimension(225, 20));
        this.difficultyDropdown = this.makeNewDropdown(QuestDetails.Difficulty.values(), "questDifficulty");
        JPanel difficultyPanel = this.makeDropdownPanel(this.difficultyDropdown, "Difficulty");
        difficultyPanel.setPreferredSize(new Dimension(225, 20));
        this.orderDropdown = this.makeNewDropdown(QuestHelperConfig.QuestOrdering.values(), "orderListBy");
        JPanel orderPanel = this.makeDropdownPanel(this.orderDropdown, "Ordering");
        orderPanel.setPreferredSize(new Dimension(225, 20));
        this.allDropdownSections.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.allDropdownSections.setLayout(new BorderLayout(0, 6));
        this.allDropdownSections.add((Component)filtersPanel, "North");
        this.allDropdownSections.add((Component)difficultyPanel, "Center");
        this.allDropdownSections.add((Component)orderPanel, "South");
        this.searchQuestsPanel.add((Component)this.allDropdownSections, "North");
        this.questListWrapper.setLayout(new BorderLayout());
        this.questListWrapper.add((Component)this.questListPanel, "North");
        this.scrollableContainer = new JScrollPane(this.questListWrapper);
        this.scrollableContainer.setHorizontalScrollBarPolicy(31);
        JPanel introDetailsPanel = new JPanel();
        introDetailsPanel.setLayout(new BorderLayout());
        introDetailsPanel.add((Component)titlePanel, "North");
        introDetailsPanel.add((Component)this.searchQuestsPanel, "Center");
        this.add(introDetailsPanel, "North");
        this.add(this.scrollableContainer, "Center");
        this.questOverviewPanel = new QuestOverviewPanel(questHelperPlugin, questManager);
        this.questOverviewWrapper.setLayout(new BorderLayout());
        this.questOverviewWrapper.add((Component)this.questOverviewPanel, "North");
    }

    private void onSearchBarChanged() {
        String text = this.searchBar.getText();
        if (this.questOverviewPanel.currentQuest == null || !text.isEmpty()) {
            this.scrollableContainer.setViewportView(this.questListWrapper);
            this.questSelectPanels.forEach(this.questListPanel::remove);
            this.showMatchingQuests(text);
        } else {
            this.scrollableContainer.setViewportView(this.questOverviewWrapper);
        }
        this.revalidate();
    }

    private JComboBox<Enum> makeNewDropdown(Enum[] values, String key) {
        JComboBox<Enum> dropdown = new JComboBox<Enum>(values);
        dropdown.setFocusable(false);
        dropdown.setForeground(Color.WHITE);
        dropdown.setRenderer(new DropdownRenderer());
        dropdown.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Enum source = (Enum)e.getItem();
                this.questHelperPlugin.getConfigManager().setConfiguration("questhelper", key, (Object)source);
            }
        });
        return dropdown;
    }

    private JPanel makeDropdownPanel(JComboBox dropdown, String name) {
        JLabel filterName = new JLabel(name);
        filterName.setForeground(Color.WHITE);
        JPanel filtersPanel = new JPanel();
        filtersPanel.setLayout(new BorderLayout());
        filtersPanel.setMinimumSize(new Dimension(225, 0));
        filtersPanel.add((Component)filterName, "Center");
        filtersPanel.add((Component)dropdown, "East");
        return filtersPanel;
    }

    private void showMatchingQuests(String text) {
        if (text.isEmpty()) {
            this.questSelectPanels.forEach(this.questListPanel::add);
            return;
        }
        String[] searchTerms = text.toLowerCase().split(" ");
        this.questSelectPanels.forEach(listItem -> {
            if (Text.matchesSearchTerms(Arrays.asList(searchTerms), listItem.getKeywords())) {
                this.questListPanel.add((Component)listItem);
            }
        });
    }

    public void refresh(List<QuestHelper> questHelpers, boolean loggedOut, Map<QuestHelperQuest, QuestState> completedQuests, QuestHelperConfig.QuestFilter ... questFilters) {
        this.questSelectPanels.forEach(this.questListPanel::remove);
        this.questSelectPanels.clear();
        this.filterDropdown.setSelectedItem(this.questHelperPlugin.getConfig().filterListBy());
        this.difficultyDropdown.setSelectedItem(this.questHelperPlugin.getConfig().difficulty());
        this.orderDropdown.setSelectedItem(this.questHelperPlugin.getConfig().orderListBy());
        if (questFilters.length > 0) {
            for (QuestHelperConfig.QuestFilter questFilter : questFilters) {
                List filterList = questHelpers.stream().filter(questFilter).collect(Collectors.toList());
                if (!filterList.isEmpty()) {
                    this.questSelectPanels.add(new QuestSelectPanel(questFilter.getDisplayName()));
                }
                for (QuestHelper questHelper : filterList) {
                    QuestState questState = completedQuests.getOrDefault((Object)questHelper.getQuest(), QuestState.NOT_STARTED);
                    this.questSelectPanels.add(new QuestSelectPanel(this.questHelperPlugin, this.questManager, this, questHelper, questState));
                }
            }
        } else {
            for (QuestHelper questHelper : questHelpers) {
                QuestState questState = completedQuests.getOrDefault((Object)questHelper.getQuest(), QuestState.NOT_STARTED);
                this.questSelectPanels.add(new QuestSelectPanel(this.questHelperPlugin, this.questManager, this, questHelper, questState));
            }
        }
        Set<QuestHelperQuest> quests = completedQuests.keySet();
        boolean hasMoreQuests = quests.stream().anyMatch(q -> completedQuests.get(q) != QuestState.FINISHED);
        if (this.questSelectPanels.isEmpty() || !hasMoreQuests) {
            this.allQuestsCompletedPanel.removeAll();
            JLabel noMatch = new JLabel();
            noMatch.setForeground(Color.GRAY);
            if (loggedOut) {
                noMatch.setText("<html><body style='text-align:left'>Log in to see available quests</body></html>");
            } else {
                noMatch.setText("<html><body style='text-align:left'>No quests are available that match your current filters</body></html>");
            }
            this.allQuestsCompletedPanel.add(noMatch);
        }
        this.allQuestsCompletedPanel.setVisible(this.questSelectPanels.isEmpty());
        this.repaint();
        this.revalidate();
        this.showMatchingQuests(this.searchBar.getText() != null ? this.searchBar.getText() : "");
    }

    public void addQuest(QuestHelper quest, boolean isActive) {
        this.allDropdownSections.setVisible(false);
        this.scrollableContainer.setViewportView(this.questOverviewWrapper);
        this.questOverviewPanel.addQuest(quest, isActive);
        this.questActive = true;
        this.repaint();
        this.revalidate();
    }

    public void updateSteps() {
        this.questOverviewPanel.updateSteps();
    }

    public void updateHighlight(Client client, QuestStep newStep) {
        this.questOverviewPanel.updateHighlight(client, newStep);
        this.repaint();
        this.revalidate();
    }

    public void updateLocks() {
        this.questOverviewPanel.updateLocks();
        this.repaint();
        this.revalidate();
    }

    public void removeQuest() {
        this.questActive = false;
        this.allDropdownSections.setVisible(true);
        this.questOverviewPanel.removeQuest();
        this.scrollableContainer.setViewportView(this.questListWrapper);
        this.repaint();
        this.revalidate();
    }

    private void activateSettings() {
        this.searchQuestsPanel.setVisible(false);
        this.repaint();
        this.revalidate();
    }

    private void deactivateSettings() {
        if (this.questActive && this.searchBar.getText().isEmpty()) {
            this.scrollableContainer.setViewportView(this.questOverviewWrapper);
        } else {
            this.scrollableContainer.setViewportView(this.questListWrapper);
        }
        this.searchQuestsPanel.setVisible(true);
        this.repaint();
        this.revalidate();
    }

    public void emptyBar() {
        this.searchBar.setText("");
    }

    public void updateItemRequirements(Client client, List<Item> bankItems) {
        this.questOverviewPanel.updateRequirements(client, bankItems);
    }
}

