/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PanelDetails {
    String header;
    private final List<QuestStep> steps;
    private QuestStep lockingQuestSteps;
    private Requirement hideCondition;
    private List<Requirement> requirements;
    private List<Requirement> recommended;
    private List<Integer> vars;

    public PanelDetails(String header) {
        this.header = header;
        this.steps = new ArrayList<QuestStep>();
    }

    public PanelDetails(String header, QuestStep ... steps) {
        this.header = header;
        this.steps = QuestUtil.toArrayList(steps);
        this.requirements = new ArrayList<Requirement>();
    }

    public PanelDetails(String header, List<QuestStep> steps, List<Requirement> requirements) {
        this.header = header;
        this.steps = steps;
        this.requirements = requirements;
    }

    public PanelDetails(String header, List<QuestStep> steps, Requirement ... requirements) {
        this(header, steps, Arrays.asList(requirements));
    }

    public PanelDetails(String header, List<QuestStep> steps, List<Requirement> requirements, List<Requirement> recommended) {
        this(header, steps, requirements);
        this.recommended = recommended;
    }

    public void setDisplayCondition(Requirement req) {
        this.setHideCondition(new Conditions(LogicType.NOR, req));
    }

    public void setVars(Integer ... vars) {
        this.vars = Arrays.asList(vars);
    }

    public void setLockingStep(QuestStep lockingStep) {
        this.lockingQuestSteps = lockingStep;
    }

    public void addSteps(QuestStep ... steps) {
        this.steps.addAll(Arrays.asList(steps));
    }

    public boolean contains(QuestStep currentStep) {
        if (this.getSteps().contains(currentStep)) {
            return true;
        }
        return this.getSteps().stream().filter(Objects::nonNull).map(QuestStep::getSubsteps).flatMap(Collection::stream).anyMatch(step -> this.containsSubStep(currentStep, (QuestStep)step));
    }

    private boolean containsSubStep(QuestStep currentStep, QuestStep check) {
        if (currentStep.getSubsteps().contains(check) || currentStep == check) {
            return true;
        }
        return currentStep.getSubsteps().stream().anyMatch(step -> this.containsSubStep((QuestStep)step, check));
    }

    public String getHeader() {
        return this.header;
    }

    public List<QuestStep> getSteps() {
        return this.steps;
    }

    public QuestStep getLockingQuestSteps() {
        return this.lockingQuestSteps;
    }

    public void setHideCondition(Requirement hideCondition) {
        this.hideCondition = hideCondition;
    }

    public Requirement getHideCondition() {
        return this.hideCondition;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Requirement> getRecommended() {
        return this.recommended;
    }

    public List<Integer> getVars() {
        return this.vars;
    }
}

