/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.function.Function;

public class DynamicPaddedGridLayout
extends GridLayout {
    public DynamicPaddedGridLayout(int rows, int cols, int horizontalPadding, int verticalPadding) {
        super(rows, cols, horizontalPadding, verticalPadding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.calculateSize(parent, Component::getPreferredSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.calculateSize(parent, Component::getMinimumSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int numComponents = parent.getComponentCount();
            int numRows = this.getRows();
            int numColumns = this.getColumns();
            if (numComponents == 0) {
                return;
            }
            if (numRows > 0) {
                numColumns = (numComponents + numRows - 1) / numRows;
            } else {
                numRows = (numComponents + numColumns - 1) / numColumns;
            }
            int horizontalPadding = this.getHgap();
            int verticalPadding = this.getVgap();
            Dimension pd = this.preferredLayoutSize(parent);
            Insets parentInsets = parent.getInsets();
            int horizontalBorder = parentInsets.left + parentInsets.right;
            int verticalBorder = parentInsets.top + parentInsets.bottom;
            double sw = (1.0 * (double)parent.getWidth() - (double)horizontalBorder) / (double)(pd.width - horizontalBorder);
            double sh = (1.0 * (double)parent.getHeight() - (double)verticalBorder) / (double)(pd.height - verticalBorder);
            int[] w = new int[numColumns];
            int[] h = new int[numRows];
            for (int i = 0; i < numComponents; ++i) {
                int r = i / numColumns;
                int c = i % numColumns;
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                d.width = (int)(sw * (double)d.width);
                d.height = (int)(sh * (double)d.height);
                if (w[c] < d.width) {
                    w[c] = d.width;
                }
                if (h[r] >= d.height) continue;
                h[r] = d.height;
            }
            int x = insets.left;
            for (int c = 0; c < numColumns; ++c) {
                int componentWidth = w[c];
                int y = insets.top;
                for (int r = 0; r < numRows; ++r) {
                    int i = r * numColumns + c;
                    int componentHeight = h[r];
                    if (i < numComponents) {
                        parent.getComponent(i).setBounds(x, y, componentWidth, componentHeight);
                    }
                    if (componentHeight <= 0) continue;
                    y += componentHeight + verticalPadding;
                }
                if (componentWidth <= 0) continue;
                x += componentWidth + horizontalPadding;
            }
        }
    }

    private Dimension calculateSize(Container parent, Function<Component, Dimension> sizer) {
        int numComponents = parent.getComponentCount();
        int numRows = this.getRows();
        int numColumns = this.getColumns();
        int numVisibleRows = 0;
        int numVisibleColumns = 0;
        if (numRows > 0) {
            numColumns = (numComponents + numRows - 1) / numRows;
        } else {
            numRows = (numComponents + numColumns - 1) / numColumns;
        }
        int[] w = new int[numColumns];
        int[] h = new int[numRows];
        for (int i = 0; i < numComponents; ++i) {
            int r = i / numColumns;
            int c = i % numColumns;
            Component comp = parent.getComponent(i);
            Dimension d = sizer.apply(comp);
            if (w[c] < d.width) {
                w[c] = d.width;
            }
            if (h[r] >= d.height) continue;
            h[r] = d.height;
        }
        int totalWidth = 0;
        int totalHeight = 0;
        for (int j = 0; j < numColumns; ++j) {
            int columnWidth = w[j];
            if (columnWidth <= 0) continue;
            totalWidth += columnWidth;
            ++numVisibleColumns;
        }
        for (int i = 0; i < numRows; ++i) {
            int rowHeight = h[i];
            if (rowHeight <= 0) continue;
            totalHeight += rowHeight;
            ++numVisibleRows;
        }
        Insets insets = parent.getInsets();
        return new Dimension(insets.left + insets.right + totalWidth + (numVisibleColumns - 1) * this.getHgap(), insets.top + insets.bottom + totalHeight + (numVisibleRows - 1) * this.getVgap());
    }
}

