/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.overlays;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class QuestHelperWorldOverlay
extends Overlay {
    public static final int IMAGE_Z_OFFSET = 30;
    private final QuestHelperPlugin plugin;

    @Inject
    public QuestHelperWorldOverlay(QuestHelperPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        boolean noOverlaysDrawn;
        boolean bl = noOverlaysDrawn = !this.plugin.getConfig().showSymbolOverlay() && this.plugin.getConfig().highlightStyleGroundItems() == QuestHelperConfig.GroundItemHighlightStyle.NONE && this.plugin.getConfig().highlightStyleNpcs() == QuestHelperConfig.NpcHighlightStyle.NONE && this.plugin.getConfig().highlightStyleObjects() == QuestHelperConfig.ObjectHighlightStyle.NONE;
        if (noOverlaysDrawn) {
            return null;
        }
        QuestHelper quest = this.plugin.getSelectedQuest();
        if (quest != null && quest.getCurrentStep() != null) {
            quest.makeWorldOverlayHint(graphics, this.plugin);
            quest.getCurrentStep().makeWorldOverlayHint(graphics, this.plugin);
        }
        this.plugin.backgroundHelpers.forEach((name, questHelper) -> questHelper.getCurrentStep().makeWorldOverlayHint(graphics, this.plugin));
        this.plugin.getRuneliteObjectManager().makeWorldOverlayHint(graphics);
        return null;
    }
}

