/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.overlays;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestDebugRenderer;
import com.questhelper.questhelpers.QuestHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class QuestHelperDebugOverlay
extends OverlayPanel
implements QuestDebugRenderer {
    private final QuestHelperPlugin plugin;
    private QuestHelper lastSeenQuest;

    @Inject
    public QuestHelperDebugOverlay(QuestHelperPlugin plugin) {
        this.plugin = plugin;
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        QuestHelper quest = this.plugin.getSelectedQuest();
        this.renderDebugOverlay(graphics, this.plugin, this.panelComponent);
        this.renderDebugWorldOverlayHint(graphics, this.plugin, quest, this.panelComponent);
        this.renderDebugWidgetOverlayHint(graphics, this.plugin, quest, this.panelComponent);
        return super.render(graphics);
    }

    @Override
    public void renderDebugOverlay(Graphics graphics, QuestHelperPlugin plugin, PanelComponent panelComponent) {
        QuestHelper currentQuest = plugin.getSelectedQuest();
        if ((this.lastSeenQuest == null || currentQuest != this.lastSeenQuest) && currentQuest != null) {
            this.lastSeenQuest = currentQuest;
        }
        if (plugin.isDeveloperMode() && this.lastSeenQuest != null) {
            this.lastSeenQuest.renderDebugOverlay(graphics, plugin, panelComponent);
        }
    }
}

