/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.managers;

import com.google.common.primitives.Ints;
import com.questhelper.managers.QuestManager;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.tools.QuestWidgets;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.util.Text;

@Singleton
public class QuestMenuHandler {
    @Inject
    private Client client;
    @Inject
    private QuestManager questManager;
    private static final int[] QUESTLIST_WIDGET_IDS = new int[]{QuestWidgets.QUEST_CONTAINER.getId()};
    private static final String[] RFD_NAMES = new String[]{QuestHelperQuest.RECIPE_FOR_DISASTER_FINALE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_SIR_AMIK_VARZE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_DWARF.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_EVIL_DAVE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_PIRATE_PETE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE.getName(), QuestHelperQuest.RECIPE_FOR_DISASTER_START.getName()};
    private static final Zone PHOENIX_START_ZONE = new Zone(new WorldPoint(3204, 3488, 0), new WorldPoint(3221, 3501, 0));
    private static final int[] ACHIEVEMENTLIST_WIDGET_IDS = new int[]{16973826};
    private static final String[] ACHIEVEMENT_TIERS = new String[]{"Elite", "Hard", "Medium", "Easy"};
    private static final String MENUOP_QUESTHELPER = "Quest Helper";
    private static final String MENUOP_GENERICHELPER = "Helper";
    private static final String MENUOP_STARTHELPER = "Start Quest Helper";
    private static final String MENUOP_STOPHELPER = "Stop Quest Helper";

    public void startUpQuest(String questName) {
        if ("Shield of Arrav".equals(questName)) {
            this.handleShieldOfArrav();
        } else if ("Recipe for Disaster".equals(questName)) {
            this.handleRecipeForDisaster();
        } else {
            this.handleGenericQuest(questName);
        }
    }

    private void handleShieldOfArrav() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        WorldPoint location = player.getWorldLocation();
        QuestHelperQuest questToStart = PHOENIX_START_ZONE.contains(location) ? QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG : QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG;
        this.questManager.startUpQuest(QuestHelperQuest.getByName(questToStart.getName()));
    }

    private void handleRecipeForDisaster() {
        this.questManager.startUpQuest(QuestHelperQuest.getByName(QuestHelperQuest.RECIPE_FOR_DISASTER_START.getName()));
    }

    private void handleGenericQuest(String questName) {
        QuestHelper questHelper = QuestHelperQuest.getByName(questName);
        if (questHelper != null) {
            this.questManager.startUpQuest(questHelper);
        }
    }

    public void setupQuestMenuOptions(MenuEntry[] menuEntries, int widgetIndex, int widgetID, String target, String option) {
        if (Ints.contains((int[])ACHIEVEMENTLIST_WIDGET_IDS, (int)widgetID) && option.contains("Open ")) {
            this.handleAchievementList(menuEntries, widgetIndex, widgetID, option);
        }
        if (Ints.contains((int[])QUESTLIST_WIDGET_IDS, (int)widgetID) && "Read journal:".equals(option)) {
            this.handleQuestList(menuEntries, widgetIndex, widgetID, target);
        }
    }

    private void handleAchievementList(MenuEntry[] menuEntries, int widgetIndex, int widgetID, String option) {
        String diary = option.replace("Journal", "").replace("Open ", "");
        diary = Text.removeTags((String)diary);
        for (String achievementTier : ACHIEVEMENT_TIERS) {
            menuEntries = this.addRightClickMenuOptions(diary + achievementTier + " Diary", MENUOP_GENERICHELPER, diary + achievementTier + " Diary", menuEntries, widgetIndex, widgetID);
        }
    }

    private void handleQuestList(MenuEntry[] menuEntries, int widgetIndex, int widgetID, String target) {
        if ("Shield of Arrav".equals(target)) {
            this.handleShieldOfArravInMenu(menuEntries, widgetIndex, widgetID);
        } else if ("Recipe for Disaster".equals(target)) {
            this.handleRecipeForDisasterInMenu(menuEntries, widgetIndex, widgetID);
        } else {
            this.handleGenericQuestInMenu(menuEntries, widgetIndex, widgetID, target);
        }
    }

    private void handleShieldOfArravInMenu(MenuEntry[] menuEntries, int widgetIndex, int widgetID) {
        if (this.questManager.getSelectedQuest() != null && this.questManager.getSelectedQuest().getQuest().getId() == QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG.getId()) {
            this.addNewEntry(menuEntries, MENUOP_STOPHELPER, "Shield of Arrav", widgetIndex, widgetID);
        } else {
            String phoenixName = QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG.getName();
            String blackArmName = QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG.getName();
            QuestHelper questHelperPhoenix = QuestHelperQuest.getByName(phoenixName);
            QuestHelper questHelperBlackArm = QuestHelperQuest.getByName(blackArmName);
            if (questHelperPhoenix != null && !questHelperPhoenix.isCompleted()) {
                menuEntries = this.addRightClickMenuOptions(phoenixName, MENUOP_QUESTHELPER, phoenixName, menuEntries, widgetIndex, widgetID);
            }
            if (questHelperBlackArm != null && !questHelperBlackArm.isCompleted()) {
                this.addRightClickMenuOptions(blackArmName, MENUOP_QUESTHELPER, blackArmName, menuEntries, widgetIndex, widgetID);
            }
        }
    }

    private void handleRecipeForDisasterInMenu(MenuEntry[] menuEntries, int widgetIndex, int widgetID) {
        if (this.questManager.getSelectedQuest() != null && this.questManager.getSelectedQuest().getQuest().getId() == QuestHelperQuest.RECIPE_FOR_DISASTER.getId()) {
            this.addRightClickMenuOptions(QuestHelperQuest.RECIPE_FOR_DISASTER.getName(), MENUOP_QUESTHELPER, "Recipe for Disaster", menuEntries, widgetIndex, widgetID);
        } else {
            for (String rfdName : RFD_NAMES) {
                menuEntries = this.addRightClickMenuOptions(rfdName, MENUOP_QUESTHELPER, rfdName, menuEntries, widgetIndex, widgetID);
            }
        }
    }

    private void handleGenericQuestInMenu(MenuEntry[] menuEntries, int widgetIndex, int widgetID, String target) {
        QuestHelper questHelper = QuestHelperQuest.getByName(target);
        if (questHelper != null && !questHelper.isCompleted()) {
            if (this.questManager.getSelectedQuest() != null && this.questManager.getSelectedQuest().getQuest().getName().equals(target)) {
                this.addNewEntry(menuEntries, MENUOP_STOPHELPER, target, widgetIndex, widgetID);
            } else {
                this.addNewEntry(menuEntries, MENUOP_STARTHELPER, target, widgetIndex, widgetID);
            }
        }
    }

    private MenuEntry[] addRightClickMenuOptions(String helperName, String entryName, String target, MenuEntry[] menuEntries, int widgetIndex, int widgetID) {
        QuestHelper questHelper = QuestHelperQuest.getByName(helperName);
        if (questHelper != null && !questHelper.isCompleted()) {
            String menuOption = MENUOP_STOPHELPER.equals(entryName) ? "Stop " + entryName : "Start " + entryName;
            return this.addNewEntry(menuEntries, menuOption, target, widgetIndex, widgetID);
        }
        return menuEntries;
    }

    private MenuEntry[] addNewEntry(MenuEntry[] menuEntries, String newEntry, String target, int widgetIndex, int widgetID) {
        MenuEntry[] newMenuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
        this.client.createMenuEntry(menuEntries.length - 1).setOption(newEntry).setTarget("<col=ff9040>" + target + "</col>").onClick(menuEntry -> this.handleMenuEntryClick(newEntry, target)).setType(MenuAction.RUNELITE).setParam0(widgetIndex).setParam1(widgetID);
        return newMenuEntries;
    }

    private void handleMenuEntryClick(String newEntry, String target) {
        if (newEntry.startsWith("Start")) {
            String quest = Text.removeTags((String)target);
            this.questManager.startUpQuest(QuestHelperQuest.getByName(quest));
        } else {
            this.questManager.shutDownQuest(true);
        }
    }
}

