/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.managers;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.managers.QuestBankManager;
import com.questhelper.panel.QuestHelperPanel;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.QuestStep;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.QuestState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;

@Singleton
public class QuestManager {
    @Inject
    Client client;
    @Inject
    ClientThread clientThread;
    @Inject
    EventBus eventBus;
    @Inject
    QuestBankManager questBankManager;
    @Inject
    QuestHelperConfig config;
    @Inject
    QuestHelperPlugin questHelperPlugin;
    @Inject
    @Named(value="developerMode")
    private boolean developerMode;
    private QuestHelper sidebarSelectedQuest;
    private QuestHelper selectedQuest;
    private boolean loadQuestList = false;
    private QuestHelperPanel panel;
    private QuestStep lastStep = null;
    public Map<String, QuestHelper> backgroundHelpers = new HashMap<String, QuestHelper>();
    public SortedMap<QuestHelperQuest, List<ItemRequirement>> itemRequirements = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();
    public SortedMap<QuestHelperQuest, List<ItemRequirement>> itemRecommended = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();

    public void startUp(QuestHelperPanel panel) {
        this.panel = panel;
    }

    public void shutDown() {
        this.panel = null;
        this.shutDownQuest(false);
    }

    public void setupOnLogin() {
        QuestHelperQuest.CHECK_ITEMS.getQuestHelper().init();
        this.getAllItemRequirements();
        this.loadQuestList = true;
    }

    public void updateQuestState() {
        this.handleSidebarQuest();
        this.handleSelectedQuest();
        this.handleQuestListUpdate();
    }

    private void handleSidebarQuest() {
        if (this.sidebarSelectedQuest != null) {
            this.startUpQuest(this.sidebarSelectedQuest);
            this.sidebarSelectedQuest = null;
        }
    }

    private void handleSelectedQuest() {
        if (this.selectedQuest != null && this.selectedQuest.getCurrentStep() != null) {
            this.panel.updateSteps();
            QuestStep currentStep = this.selectedQuest.getCurrentStep().getSidePanelStep();
            if (currentStep != null && currentStep != this.lastStep) {
                this.lastStep = currentStep;
                this.panel.updateHighlight(this.client, currentStep);
            }
            if (this.panel.questActive) {
                this.clientThread.invokeLater(() -> this.panel.updateItemRequirements(this.client, this.questBankManager.getBankItems()));
            }
            this.panel.updateLocks();
        }
    }

    private void handleQuestListUpdate() {
        if (this.loadQuestList) {
            this.loadQuestList = false;
            this.updateQuestList();
            this.getAllItemRequirements();
        }
    }

    public void handleVarbitChanged() {
        if (this.selectedQuest == null) {
            return;
        }
        if (this.selectedQuest.updateQuest() && this.selectedQuest.getCurrentStep() == null) {
            this.shutDownQuest(true);
        }
        this.clientThread.invokeLater(() -> {
            if (this.selectedQuest != null && this.selectedQuest.isCompleted()) {
                this.shutDownQuest(true);
            }
        });
    }

    public void handleConfigChanged() {
        this.clientThread.invokeLater(() -> {
            if (this.selectedQuest != null && this.selectedQuest.isCompleted()) {
                this.shutDownQuest(true);
            }
        });
    }

    public void updateQuestList() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            List filteredQuests = QuestHelperQuest.getQuestHelpers().stream().filter(this.config.filterListBy()).filter(this.config.difficulty()).filter(QuestDetails::showCompletedQuests).sorted(this.config.orderListBy()).collect(Collectors.toList());
            Map<QuestHelperQuest, QuestState> completedQuests = QuestHelperQuest.getQuestHelpers().stream().collect(Collectors.toMap(QuestHelper::getQuest, q -> q.getState(this.client)));
            SwingUtilities.invokeLater(() -> this.panel.refresh(filteredQuests, false, completedQuests, this.config.orderListBy().getSections()));
        }
    }

    public void startUpQuest(QuestHelper questHelper) {
        this.startUpQuest(questHelper, true);
    }

    public void startUpQuest(QuestHelper questHelper, boolean shouldOpenSidebarIfConfig) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.shutDownPreviousQuest();
        this.initializeNewQuest(questHelper, shouldOpenSidebarIfConfig);
    }

    private void initializeNewQuest(QuestHelper questHelper, boolean shouldOpenSidebarIfConfig) {
        if (!questHelper.isCompleted()) {
            if (this.backgroundHelpers.containsValue(questHelper)) {
                this.shutDownBackgroundQuest(questHelper);
            }
            if (shouldOpenSidebarIfConfig && this.config.autoOpenSidebar()) {
                this.questHelperPlugin.displayPanel();
            }
            this.selectedQuest = questHelper;
            this.eventBus.register((Object)this.selectedQuest);
            if (this.isDeveloperMode()) {
                this.selectedQuest.debugStartup(this.config);
            }
            this.selectedQuest.startUp(this.config);
            if (this.selectedQuest.getCurrentStep() == null) {
                this.shutDownQuest(false);
                return;
            }
            this.questBankManager.startUpQuest();
            SwingUtilities.invokeLater(() -> {
                this.panel.removeQuest();
                this.panel.addQuest(questHelper, true);
            });
        } else {
            this.panel.removeQuest();
            this.selectedQuest = null;
        }
    }

    public void shutDownQuestFromSidebar() {
        if (this.selectedQuest != null) {
            this.selectedQuest.shutDown();
            this.questBankManager.shutDownQuest();
            SwingUtilities.invokeLater(this.panel::removeQuest);
            this.eventBus.unregister((Object)this.selectedQuest);
            if (this.selectedQuest.getQuest() == QuestHelperQuest.CHECK_ITEMS && this.config.highlightItemsBackground()) {
                this.selectedQuest = null;
                this.startUpBackgroundQuest(QuestHelperQuest.CHECK_ITEMS.getName());
            } else {
                this.selectedQuest = null;
            }
        }
    }

    private void shutDownPreviousQuest() {
        this.shutDownQuest(true);
    }

    public void shutDownQuest(boolean shouldUpdateList) {
        if (this.selectedQuest != null) {
            this.selectedQuest.shutDown();
            if (shouldUpdateList) {
                this.updateQuestList();
                this.getAllItemRequirements();
            }
            this.questBankManager.shutDownQuest();
            SwingUtilities.invokeLater(this.panel::removeQuest);
            this.eventBus.unregister((Object)this.selectedQuest);
            this.selectedQuest = null;
        }
    }

    public void startUpBackgroundQuest(String questHelperName) {
        if (!this.config.highlightItemsBackground()) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.backgroundHelpers.containsKey(questHelperName)) {
            return;
        }
        if (this.selectedQuest != null && this.selectedQuest.getQuest().getName().equals(questHelperName)) {
            return;
        }
        QuestHelper questHelper = QuestHelperQuest.getByName(questHelperName);
        if (questHelper == null) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (!questHelper.isCompleted()) {
                this.eventBus.register((Object)questHelper);
                questHelper.startUp(this.config);
                this.backgroundHelpers.put(questHelperName, questHelper);
                if (questHelper.getCurrentStep() == null) {
                    questHelper.shutDown();
                    this.eventBus.unregister((Object)questHelper);
                    this.backgroundHelpers.remove(questHelperName);
                }
            }
        });
    }

    private void shutDownBackgroundQuest(QuestHelper questHelper) {
        if (questHelper == null) {
            return;
        }
        if (!this.backgroundHelpers.containsKey(questHelper.getQuest().getName())) {
            return;
        }
        if (questHelper == this.selectedQuest) {
            return;
        }
        questHelper.shutDown();
        this.eventBus.unregister((Object)questHelper);
        this.backgroundHelpers.remove(questHelper.getQuest().getName());
    }

    private void getAllItemRequirements() {
        this.clientThread.invokeLater(() -> {
            Predicate<QuestHelper> pred = questHelper -> false;
            if (this.config.highlightNeededQuestItems()) {
                pred = pred.or(QuestHelperConfig.QuestFilter.QUEST);
            }
            if (this.config.highlightNeededMiniquestItems()) {
                pred = pred.or(QuestHelperConfig.QuestFilter.MINIQUEST);
            }
            if (this.config.highlightNeededAchievementDiaryItems()) {
                pred = pred.or(QuestHelperConfig.QuestFilter.ACHIEVEMENT_DIARY);
            }
            List filteredQuests = QuestHelperQuest.getQuestHelpers().stream().filter(pred).filter(QuestDetails::isNotCompleted).sorted(this.config.orderListBy()).collect(Collectors.toList());
            this.clientThread.invokeLater(() -> {
                TreeMap<QuestHelperQuest, List<ItemRequirement>> newReqs = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();
                TreeMap<QuestHelperQuest, List<ItemRequirement>> newRecommended = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();
                filteredQuests.forEach(questHelper -> {
                    if (questHelper.getItemRequirements() != null) {
                        newReqs.put(questHelper.getQuest(), questHelper.getItemRequirements());
                    }
                    if (questHelper.getItemRecommended() != null) {
                        newRecommended.put(questHelper.getQuest(), questHelper.getItemRecommended());
                    }
                });
                this.itemRequirements = newReqs;
                this.itemRecommended = newRecommended;
                String checkItemsName = QuestHelperQuest.CHECK_ITEMS.getName();
                if (this.config.highlightItemsBackground()) {
                    this.shutDownBackgroundQuest(this.backgroundHelpers.get(checkItemsName));
                    this.startUpBackgroundQuest(checkItemsName);
                }
            });
        });
    }

    public void updateAllItemsHelper() {
        this.getAllItemRequirements();
        if (this.selectedQuest != null && this.selectedQuest.getQuest() == QuestHelperQuest.CHECK_ITEMS) {
            this.clientThread.invokeLater(() -> this.startUpQuest(QuestHelperQuest.CHECK_ITEMS.getQuestHelper(), false));
        }
    }

    public void updateAllItemsBackgroundHelper(String shouldRun) {
        if (Objects.equals(shouldRun, "false")) {
            this.shutDownBackgroundQuest(this.backgroundHelpers.get(QuestHelperQuest.CHECK_ITEMS.getName()));
        } else {
            this.startUpBackgroundQuest(QuestHelperQuest.CHECK_ITEMS.getName());
        }
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setSidebarSelectedQuest(QuestHelper sidebarSelectedQuest) {
        this.sidebarSelectedQuest = sidebarSelectedQuest;
    }

    public QuestHelper getSelectedQuest() {
        return this.selectedQuest;
    }
}

