/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.managers;

import com.google.inject.Injector;
import com.questhelper.bank.QuestBank;
import com.questhelper.bank.banktab.QuestBankTab;
import com.questhelper.bank.banktab.QuestHelperBankTagService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.client.eventbus.EventBus;

@Singleton
public class QuestBankManager {
    @Inject
    private QuestBank questBank;
    @Inject
    private QuestHelperBankTagService bankTagService;
    @Inject
    private QuestBankTab questBankTab;
    private boolean loggedInStateKnown;

    public void startUp(Injector injector, EventBus eventBus) {
        this.questBankTab.startUp();
        injector.injectMembers((Object)this.questBankTab);
        eventBus.register((Object)this.questBankTab);
    }

    public void shutDown(EventBus eventBus) {
        eventBus.unregister((Object)this.questBankTab);
        this.questBankTab.shutDown();
    }

    public void loadInitialStateFromConfig(Client client) {
        Player localPlayer;
        if (!this.loggedInStateKnown && (localPlayer = client.getLocalPlayer()) != null && localPlayer.getName() != null) {
            this.loggedInStateKnown = true;
            this.loadState();
        }
    }

    public void setUnknownInitialState() {
        this.loggedInStateKnown = false;
    }

    public void loadState() {
        this.questBank.loadState();
    }

    public void startUpQuest() {
        this.questBankTab.startUp();
    }

    public void shutDownQuest() {
        this.questBankTab.shutDown();
    }

    public List<Item> getBankItems() {
        return this.questBank.getBankItems();
    }

    public void refreshBankTab() {
        this.questBankTab.refreshBankTab();
    }

    public void updateLocalBank(ItemContainer itemContainer) {
        this.questBank.updateLocalBank(itemContainer.getItems());
    }

    public void saveBankToConfig() {
        this.questBank.saveBankToConfig();
    }

    public void emptyState() {
        this.questBank.emptyState();
    }

    public QuestHelperBankTagService getBankTagService() {
        return this.bankTagService;
    }
}

