/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.woodcutting;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WOODCUTTING)
public class Woodcutting
extends ComplexStateQuestHelper {
    ItemRequirement ironAxe;
    ItemRequirement steelAxe;
    ItemRequirement blackAxe;
    ItemRequirement mithrilAxe;
    ItemRequirement adamantAxe;
    ItemRequirement runeAxe;
    SkillRequirement wc6;
    SkillRequirement wc11;
    SkillRequirement wc21;
    SkillRequirement wc31;
    SkillRequirement wc41;
    SkillRequirement wc61;
    SkillRequirement wc15;
    SkillRequirement wc30;
    QuestStep chopNormalTree;
    QuestStep chopOakTrees;
    QuestStep chopWillowTrees;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep fullTraining = new ConditionalStep((QuestHelper)this, this.chopNormalTree, new Requirement[0]);
        fullTraining.addStep(this.wc30, this.chopWillowTrees);
        fullTraining.addStep(this.wc15, this.chopOakTrees);
        return fullTraining;
    }

    @Override
    public void setupRequirements() {
        this.wc6 = new SkillRequirement(Skill.WOODCUTTING, 6);
        this.wc11 = new SkillRequirement(Skill.WOODCUTTING, 11);
        this.wc21 = new SkillRequirement(Skill.WOODCUTTING, 21);
        this.wc31 = new SkillRequirement(Skill.WOODCUTTING, 31);
        this.wc41 = new SkillRequirement(Skill.WOODCUTTING, 41);
        this.wc61 = new SkillRequirement(Skill.WOODCUTTING, 61);
        this.wc15 = new SkillRequirement(Skill.WOODCUTTING, 15);
        this.wc30 = new SkillRequirement(Skill.WOODCUTTING, 30);
        this.ironAxe = new ItemRequirement("Iron axe", 1349).showConditioned(new Conditions(LogicType.NOR, this.wc6)).isNotConsumed();
        this.steelAxe = new ItemRequirement("Steel axe", 1353).showConditioned(new Conditions(this.wc6, new Conditions(LogicType.NOR, this.wc11))).isNotConsumed();
        this.blackAxe = new ItemRequirement("Black axe", 1361).showConditioned(new Conditions(this.wc11, new Conditions(LogicType.NOR, this.wc21))).isNotConsumed();
        this.mithrilAxe = new ItemRequirement("Mithril axe", 1355).showConditioned(new Conditions(this.wc21, new Conditions(LogicType.NOR, this.wc31))).isNotConsumed();
        this.adamantAxe = new ItemRequirement("Adamant axe", 1357).showConditioned(new Conditions(this.wc31, new Conditions(LogicType.NOR, this.wc41))).isNotConsumed();
        this.runeAxe = new ItemRequirement("Rune axe", 1359).showConditioned(new Conditions(this.wc41)).isNotConsumed();
    }

    private void setupSteps() {
        this.chopNormalTree = new ObjectStep((QuestHelper)this, 1276, new WorldPoint(3192, 3223, 0), "Chop normal trees around Lumbridge until 15 Woodcutting. You can choose to burn the logs as you go, drop them, or bank them.", true, this.ironAxe, this.steelAxe, this.blackAxe);
        this.chopOakTrees = new ObjectStep((QuestHelper)this, 10820, new WorldPoint(3190, 3247, 0), "Chop oak trees around Lumbridge until 30 Woodcutting. You can choose to burn the logs as you go, drop them, or bank them.", true, this.steelAxe, this.blackAxe, this.mithrilAxe, this.adamantAxe);
        this.chopWillowTrees = new ObjectStep((QuestHelper)this, 10819, new WorldPoint(3059, 3253, 0), "Chop willow trees east of the Rusty Anchor Inn in Port Sarim until 99 Woodcutting. You can deposit them at the bank deposit box just south on the docks next to the monks. If choose to burn the logs as you go or drop them, oak trees gives faster XP until 60 Woodcutting", true, this.steelAxe, this.blackAxe, this.mithrilAxe, this.adamantAxe, this.runeAxe);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to purchase Woodcutting Cape for 99k"));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.ironAxe, this.steelAxe, this.blackAxe, this.mithrilAxe, this.adamantAxe, this.runeAxe);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("1 - 15: Cut normal trees", Collections.singletonList(this.chopNormalTree), this.ironAxe, this.steelAxe, this.blackAxe));
        allSteps.add(new PanelDetails("15 - 30: Cut oak trees", Collections.singletonList(this.chopOakTrees), this.steelAxe, this.blackAxe, this.mithrilAxe, this.adamantAxe));
        allSteps.add(new PanelDetails("30 - 99: Cut willow trees", Collections.singletonList(this.chopWillowTrees), this.steelAxe, this.blackAxe, this.mithrilAxe, this.adamantAxe, this.runeAxe));
        return allSteps;
    }
}

